/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.query;

import java.util.ArrayList;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.query.AbstractQueryTest;

public class QueryTest
extends AbstractQueryTest {
    public void testQueryChildNodesOfRoot() throws RepositoryException, NotExecutableException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeIterator it = this.superuser.getRootNode().getNodes();
        while (it.hasNext()) {
            nodes.add(it.nextNode());
        }
        Node[] children = nodes.toArray(new Node[nodes.size()]);
        this.executeXPathQuery(this.superuser, "/jcr:root/*", children);
    }

    public void testRemappedNamespace() throws RepositoryException, NotExecutableException {
        String namespaceURI = "http://jackrabbit.apache.org/spi/test";
        String defaultPrefix = "spiTest";
        NamespaceRegistry nsReg = this.superuser.getWorkspace().getNamespaceRegistry();
        try {
            nsReg.getPrefix(namespaceURI);
        }
        catch (RepositoryException e) {
            nsReg.registerNamespace(defaultPrefix, namespaceURI);
        }
        Node n = this.testRootNode.addNode("spiTest:node");
        this.superuser.save();
        for (int i = 0; i < 10; ++i) {
            String prefix = defaultPrefix + i;
            this.superuser.setNamespacePrefix(prefix, namespaceURI);
            this.executeXPathQuery(this.superuser, this.testPath + "/" + prefix + ":node", new Node[]{n});
        }
    }

    public void testSQL2Simple() throws Exception {
        Query q = this.qm.createQuery("SELECT * FROM [nt:unstructured]", "JCR-SQL2");
        QueryResult r = q.execute();
        QueryTest.assertTrue((boolean)r.getNodes().hasNext());
    }

    public void testSQL2Limit() throws Exception {
        Query q = this.qm.createQuery("SELECT * FROM [nt:unstructured]", "JCR-SQL2");
        q.setLimit(1L);
        QueryResult r = q.execute();
        NodeIterator it = r.getNodes();
        QueryTest.assertTrue((boolean)it.hasNext());
        it.next();
        QueryTest.assertFalse((boolean)it.hasNext());
    }

    public void testSQL2Join() throws Exception {
        Query q = this.qm.createQuery("SELECT * FROM [nt:unstructured] AS a INNER JOIN [nt:unstructured] AS b ON b.[refid] = a.[jcr:uuid]", "JCR-SQL2");
        QueryTest.assertNotNull((Object)q.execute());
    }
}

