/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.security.authorization.jackrabbit.acl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.Privilege;
import junit.framework.Assert;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.jcr2spi.security.authorization.jackrabbit.acl.AccessControlListImpl;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.value.QValueFactoryImpl;
import org.apache.jackrabbit.test.api.security.AbstractAccessControlTest;

public class AccessControlListImplTest
extends AbstractAccessControlTest {
    private QValueFactory vFactory;
    private Principal unknownPrincipal;
    private Principal knownPrincipal;
    private NamePathResolver resolver;

    public void setUp() throws Exception {
        super.setUp();
        this.resolver = new DefaultNamePathResolver(this.superuser);
        this.vFactory = QValueFactoryImpl.getInstance();
        this.unknownPrincipal = this.getHelper().getUnknownPrincipal(this.superuser);
        this.knownPrincipal = new Principal(){

            @Override
            public String getName() {
                return "everyone";
            }
        };
    }

    private JackrabbitAccessControlList createAccessControList(String aclPath) throws RepositoryException {
        return new AccessControlListImpl(aclPath, this.resolver, this.vFactory);
    }

    private Map<String, Value> createEmptyRestriction() {
        return Collections.emptyMap();
    }

    public void testAddingDifferentEntries() throws Exception {
        JackrabbitAccessControlList acl = this.createAccessControList(this.testRoot);
        Privilege[] p = this.privilegesFromName("{http://www.jcp.org/jcr/1.0}read");
        acl.addAccessControlEntry(this.unknownPrincipal, p);
        p = this.privilegesFromName("{http://www.jcp.org/jcr/1.0}addChildNodes");
        acl.addAccessControlEntry(this.knownPrincipal, p);
        p = this.privilegesFromName("{http://www.jcp.org/jcr/1.0}modifyAccessControl");
        acl.addEntry(this.unknownPrincipal, p, false);
        p = this.privilegesFromName("{http://www.jcp.org/jcr/1.0}nodeTypeManagement");
        acl.addEntry(this.knownPrincipal, p, false);
        Assert.assertEquals((int)4, (int)acl.size());
        AccessControlEntry[] pentries = this.getEntries((AccessControlList)acl, this.unknownPrincipal);
        Assert.assertEquals((int)2, (int)pentries.length);
        AccessControlEntry[] sentries = this.getEntries((AccessControlList)acl, this.knownPrincipal);
        Assert.assertEquals((int)2, (int)sentries.length);
    }

    public void testMultipleEntryEffect() throws Exception {
        JackrabbitAccessControlList acl = this.createAccessControList(this.testRoot);
        Privilege[] privileges = this.privilegesFromName("{http://www.jcp.org/jcr/1.0}read");
        AccessControlListImplTest.assertTrue((boolean)acl.addAccessControlEntry(this.unknownPrincipal, privileges));
        AccessControlListImplTest.assertEquals((int)1, (int)acl.size());
        AccessControlEntry[] entries = acl.getAccessControlEntries();
        AccessControlListImplTest.assertEquals((int)1, (int)entries[0].getPrivileges().length);
        AccessControlListImplTest.assertEquals((String)"jcr:read", (String)entries[0].getPrivileges()[0].getName());
        privileges = this.privilegesFromNames(new String[]{"{http://www.jcp.org/jcr/1.0}addChildNodes", "{http://www.jcp.org/jcr/1.0}read"});
        AccessControlListImplTest.assertTrue((boolean)acl.addAccessControlEntry(this.unknownPrincipal, privileges));
        AccessControlListImplTest.assertEquals((int)2, (int)acl.size());
        AccessControlListImplTest.assertEquals((int)1, (int)acl.getAccessControlEntries()[0].getPrivileges().length);
        AccessControlListImplTest.assertEquals((int)2, (int)acl.getAccessControlEntries()[1].getPrivileges().length);
        privileges = this.privilegesFromNames(new String[]{"{http://www.jcp.org/jcr/1.0}read"});
        AccessControlListImplTest.assertTrue((boolean)acl.addAccessControlEntry(this.unknownPrincipal, privileges));
        AccessControlListImplTest.assertEquals((int)3, (int)acl.size());
        AccessControlListImplTest.assertTrue((String)"Fail to revoke read privilege", (boolean)acl.addEntry(this.unknownPrincipal, privileges, false, this.createEmptyRestriction()));
        AccessControlListImplTest.assertEquals((int)4, (int)acl.size());
    }

    public void testMultipleEntryEffect2() throws Exception {
        JackrabbitAccessControlList acl = this.createAccessControList(this.testRoot);
        Privilege[] privileges = this.privilegesFromNames(new String[]{"{http://www.jcp.org/jcr/1.0}read"});
        AccessControlListImplTest.assertTrue((String)"New Entry -> grants read privilege", (boolean)acl.addAccessControlEntry(this.unknownPrincipal, privileges));
        AccessControlListImplTest.assertTrue((String)"Fail to revoke the read privilege", (boolean)acl.addEntry(this.unknownPrincipal, privileges, false, this.createEmptyRestriction()));
        Assert.assertEquals((int)2, (int)acl.size());
    }

    private AccessControlEntry[] getEntries(AccessControlList acl, Principal princ) throws RepositoryException {
        AccessControlEntry[] entries = acl.getAccessControlEntries();
        ArrayList<AccessControlEntry> entriesPerPrincipal = new ArrayList<AccessControlEntry>(2);
        for (AccessControlEntry entry : entries) {
            if (!entry.getPrincipal().getName().equals(princ.getName())) continue;
            entriesPerPrincipal.add(entry);
        }
        return entriesPerPrincipal.toArray(new AccessControlEntry[entriesPerPrincipal.size()]);
    }
}

