/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.security.authorization.jackrabbit.acl;

import java.security.Principal;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.jcr2spi.security.authorization.jackrabbit.acl.AccessControlListImpl;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.security.AbstractAccessControlTest;

public class AccessControlManagerImplTest
extends AbstractAccessControlTest {
    public void setUp() throws Exception {
        super.setUp();
    }

    private Principal getUnknownPrincipal() throws NotExecutableException, RepositoryException {
        return this.getHelper().getUnknownPrincipal(this.superuser);
    }

    public void testGetAndHasPrivileges() throws Exception {
        Privilege[] privileges = this.acMgr.getPrivileges(this.testRoot);
        AccessControlManagerImplTest.assertNotNull((Object)privileges);
        AccessControlManagerImplTest.assertTrue((boolean)this.acMgr.hasPrivileges(this.testRoot, privileges));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetPolicesAfterSetPoliciesCall() throws Exception {
        try {
            AccessControlPolicyIterator policies = this.acMgr.getApplicablePolicies(this.testRoot);
            AccessControlPolicy policy = null;
            while (policies.hasNext()) {
                policy = policies.nextAccessControlPolicy();
                this.acMgr.setPolicy(this.testRoot, policy);
                AccessControlPolicy[] acl = this.acMgr.getPolicies(this.testRoot);
                AccessControlManagerImplTest.assertNotNull((Object)acl);
            }
        }
        finally {
            this.superuser.refresh(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemovePolicyAfterASetPoliciesCall() throws Exception {
        try {
            AccessControlPolicyIterator policies = this.acMgr.getApplicablePolicies(this.testRoot);
            while (policies.hasNext()) {
                AccessControlListImpl acl = (AccessControlListImpl)policies.nextAccessControlPolicy();
                acl.addAccessControlEntry(this.getUnknownPrincipal(), this.privilegesFromName("{http://www.jcp.org/jcr/1.0}read"));
                this.acMgr.setPolicy(this.testRoot, (AccessControlPolicy)acl);
                AccessControlPolicy[] transientPolicy = this.acMgr.getPolicies(this.testRoot);
                this.acMgr.removePolicy(this.testRoot, transientPolicy[0]);
                AccessControlManagerImplTest.assertEquals((int)0, (int)this.acMgr.getPolicies(this.testRoot).length);
            }
        }
        finally {
            this.superuser.refresh(false);
        }
    }

    public void testRemovePolicyAfterASaveCall() throws Exception {
        try {
            AccessControlList[] acl = (AccessControlList[])this.acMgr.getPolicies(this.testRoot);
            if (acl.length > 0) {
                this.acMgr.removePolicy(this.testRoot, (AccessControlPolicy)acl[0]);
            } else {
                AccessControlPolicy policy = this.acMgr.getApplicablePolicies(this.testRoot).nextAccessControlPolicy();
                this.acMgr.setPolicy(this.testRoot, policy);
                this.acMgr.removePolicy(this.testRoot, policy);
            }
            AccessControlPolicy[] noPolicies = this.acMgr.getPolicies(this.testRoot);
            AccessControlManagerImplTest.assertEquals((int)0, (int)noPolicies.length);
            this.superuser.save();
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            this.superuser.refresh(false);
        }
    }

    public void testGetPrivilegesOnNonExistingNode() throws Exception {
        try {
            this.acMgr.getPrivileges(this.getPathToNonExistingNode());
            AccessControlManagerImplTest.fail((String)"Must throw a PathNotFoundException");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddingFourAccessControlEntries() throws Exception {
        try {
            AccessControlList acl = (AccessControlList)this.getACL(this.testRoot);
            if (this.testRootNode.hasNode("rep:policy")) {
                AccessControlManagerImplTest.assertEquals((String)"should not have any ace nodes at this point", (long)0L, (long)this.testRootNode.getNode("rep:policy").getNodes().getSize());
            }
            acl.addAccessControlEntry(this.getUnknownPrincipal(), this.privilegesFromName("{http://www.jcp.org/jcr/1.0}read"));
            acl.addAccessControlEntry(this.getUnknownPrincipal(), this.privilegesFromName("{http://www.jcp.org/jcr/1.0}read"));
            acl.addAccessControlEntry(this.getUnknownPrincipal(), this.privilegesFromName("{http://www.jcp.org/jcr/1.0}read"));
            acl.addAccessControlEntry(this.getUnknownPrincipal(), this.privilegesFromName("{http://www.jcp.org/jcr/1.0}read"));
            this.acMgr.setPolicy(this.testRoot, (AccessControlPolicy)acl);
            AccessControlManagerImplTest.assertEquals((long)4L, (long)this.testRootNode.getNode("rep:policy").getNodes().getSize());
            this.superuser.save();
            AccessControlManagerImplTest.assertEquals((long)1L, (long)this.testRootNode.getNode("rep:policy").getNodes().getSize());
        }
        finally {
            this.superuser.refresh(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetPoliciesAfterASaveCall() throws Exception {
        try {
            JackrabbitAccessControlList policy = (JackrabbitAccessControlList)this.getACL(this.testRoot);
            String aclPath = policy.getPath();
            AccessControlManagerImplTest.assertEquals((String)aclPath, (String)this.testRoot);
            policy.addAccessControlEntry(this.getUnknownPrincipal(), this.privilegesFromName("{http://www.jcp.org/jcr/1.0}read"));
            policy.addAccessControlEntry(this.getUnknownPrincipal(), this.privilegesFromName("{http://www.jcp.org/jcr/1.0}addChildNodes"));
            this.acMgr.setPolicy(this.testRoot, (AccessControlPolicy)policy);
            this.superuser.save();
            Node aclNode = this.testRootNode.getNode("rep:policy");
            AccessControlManagerImplTest.assertNotNull((Object)aclNode);
            NodeIterator nit = aclNode.getNodes();
            AccessControlManagerImplTest.assertEquals((long)1L, (long)nit.getSize());
        }
        finally {
            this.superuser.refresh(false);
        }
    }

    private AccessControlPolicy getACL(String absPath) throws RepositoryException {
        AccessControlList acl = null;
        acl = this.acMgr.getPolicies(absPath).length > 0 ? (AccessControlList)this.acMgr.getPolicies(absPath)[0] : (AccessControlList)this.acMgr.getApplicablePolicies(absPath).nextAccessControlPolicy();
        return acl;
    }
}

