/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.version;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.apache.jackrabbit.test.api.version.VersionLabelTest;

public class LabelTest
extends VersionLabelTest {
    public void testRemovedLabel2() throws RepositoryException {
        this.vHistory.addVersionLabel(this.version.getName(), this.versionLabel, false);
        this.vHistory.removeVersionLabel(this.versionLabel);
        List<String> labels = Arrays.asList(this.vHistory.getVersionLabels());
        LabelTest.assertFalse((String)"VersionHistory.getVersionLabels() must not return a removed label.", (boolean)labels.contains(this.versionLabel));
    }

    public void testRemovedLabel3() throws RepositoryException {
        this.vHistory.addVersionLabel(this.version.getName(), this.versionLabel, false);
        this.vHistory.removeVersionLabel(this.versionLabel);
        List<String> labels = Arrays.asList(this.vHistory.getVersionLabels(this.version));
        LabelTest.assertFalse((String)"VersionHistory.getVersionLabels(Version) must not return a removed label.", (boolean)labels.contains(this.versionLabel));
    }

    public void testMoveLabel2() throws RepositoryException {
        this.vHistory.addVersionLabel(this.version.getName(), this.versionLabel, false);
        this.versionableNode.checkout();
        Version v = this.versionableNode.checkin();
        this.vHistory.addVersionLabel(v.getName(), this.versionLabel, true);
        List<String> labels = Arrays.asList(this.vHistory.getVersionLabels(v));
        LabelTest.assertTrue((boolean)labels.contains(this.versionLabel));
    }

    public void testMoveLabel3() throws RepositoryException {
        this.versionableNode.checkout();
        Version v = this.versionableNode.checkin();
        this.vHistory.addVersionLabel(this.version.getName(), this.versionLabel, false);
        this.vHistory.addVersionLabel(v.getName(), this.versionLabel, true);
        List<String> labels = Arrays.asList(this.vHistory.getVersionLabels(this.version));
        LabelTest.assertFalse((boolean)labels.contains(this.versionLabel));
    }

    public void testMoveLabel4() throws RepositoryException {
        this.versionableNode.checkout();
        Version v = this.versionableNode.checkin();
        this.vHistory.addVersionLabel(this.version.getName(), this.versionLabel, false);
        this.vHistory.addVersionLabel(v.getName(), this.versionLabel, true);
        Version v2 = this.vHistory.getVersionByLabel(this.versionLabel);
        LabelTest.assertTrue((boolean)v2.isSame((Item)v));
    }
}

