/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SessionImportTest
extends AbstractJCRTest {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testImportNameValueWithUnregisteredNamespace() throws RepositoryException, SAXException {
        String prefix = SessionImportTest.getUniquePrefix(this.superuser);
        String uri = SessionImportTest.getUnknownURI(this.superuser, "anyURI");
        String testValue = prefix + ":someLocalName";
        String svuri = "http://www.jcp.org/jcr/sv/1.0";
        String svprefix = "sv:";
        ContentHandler ch = this.superuser.getImportContentHandler(this.testRootNode.getPath(), 0);
        ch.startDocument();
        ch.startPrefixMapping(prefix, uri);
        String nN = "node";
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute(svuri, "name", svprefix + "name", "CDATA", this.nodeName1);
        ch.startElement(svuri, nN, svprefix + nN, attrs);
        String pN = "property";
        attrs = new AttributesImpl();
        attrs.addAttribute(svuri, "name", svprefix + "name", "CDATA", "jcr:primaryType");
        attrs.addAttribute(svuri, "type", svprefix + "type", "CDATA", PropertyType.nameFromValue((int)7));
        ch.startElement(svuri, pN, svprefix + pN, attrs);
        ch.startElement(svuri, "value", svprefix + "value", new AttributesImpl());
        char[] val = this.testNodeType.toCharArray();
        ch.characters(val, 0, val.length);
        ch.endElement(svuri, "value", svprefix + "value");
        ch.endElement(svuri, pN, prefix + pN);
        attrs = new AttributesImpl();
        attrs.addAttribute(svuri, "name", svprefix + "name", "CDATA", this.propertyName1);
        attrs.addAttribute(svuri, "type", svprefix + "type", "CDATA", PropertyType.nameFromValue((int)7));
        ch.startElement(svuri, pN, svprefix + pN, attrs);
        ch.startElement(svuri, "value", svprefix + "value", new AttributesImpl());
        val = testValue.toCharArray();
        ch.characters(val, 0, val.length);
        ch.endElement(svuri, "value", svprefix + "value");
        ch.endElement(svuri, pN, svprefix + pN);
        ch.endElement(svuri, nN, svprefix + nN);
        ch.endDocument();
        String assignedPrefix = this.superuser.getNamespacePrefix(uri);
        SessionImportTest.assertTrue((boolean)this.superuser.getNamespaceURI(assignedPrefix).equals(uri));
        String path = this.testRootNode.getPath() + "/" + this.nodeName1 + "/" + this.propertyName1;
        SessionImportTest.assertTrue((boolean)this.superuser.itemExists(path));
        Item item = this.superuser.getItem(path);
        if (item.isNode()) {
            SessionImportTest.fail((String)("Item with path " + path + " must be a property."));
        } else {
            Property prop = (Property)item;
            SessionImportTest.assertTrue((prop.getValue().getType() == 7 ? 1 : 0) != 0);
            String expectedValue = assignedPrefix + ":someLocalName";
            SessionImportTest.assertTrue((boolean)prop.getValue().getString().equals(expectedValue));
        }
        this.superuser.save();
    }

    public void testEmptyMixins() throws IOException, RepositoryException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<sv:node xmlns:nt=\"http://www.jcp.org/jcr/nt/1.0\"\n         xmlns:sv=\"http://www.jcp.org/jcr/sv/1.0\"\n         xmlns:mix=\"http://www.jcp.org/jcr/mix/1.0\"\n         xmlns:jcr=\"http://www.jcp.org/jcr/1.0\"\n         sv:name=\"testnode1\">\n    <sv:property sv:name=\"jcr:primaryType\" sv:type=\"Name\">\n        <sv:value>nt:unstructured</sv:value>\n    </sv:property>\n    <sv:property sv:name=\"jcr:title\" sv:type=\"String\">\n        <sv:value>Test Node</sv:value>\n    </sv:property>\n    <sv:property sv:name=\"jcr:uuid\" sv:type=\"String\">\n        <sv:value>1234</sv:value>\n    </sv:property>\n</sv:node>";
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        try {
            this.superuser.importXML(this.testRootNode.getPath(), (InputStream)in, 3);
            SessionImportTest.fail((String)"jcr:uuid cannot be created if mix:referenceable is not part of the effective nodetype.");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testEmptyMixins2() throws IOException, RepositoryException, NotExecutableException {
        String referenceableNt = null;
        NodeTypeIterator it = this.superuser.getWorkspace().getNodeTypeManager().getPrimaryNodeTypes();
        while (it.hasNext() && referenceableNt == null) {
            NodeType nt = it.nextNodeType();
            String ntName = nt.getName();
            if (!nt.isNodeType(this.mixReferenceable) || nt.isAbstract() || ntName.startsWith("nt:") || ntName.startsWith("rep:")) continue;
            referenceableNt = ntName;
        }
        if (referenceableNt == null) {
            throw new NotExecutableException("No primary type found that extends from mix:referenceable.");
        }
        String uuid = UUID.randomUUID().toString();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<sv:node xmlns:nt=\"http://www.jcp.org/jcr/nt/1.0\"\n         xmlns:sv=\"http://www.jcp.org/jcr/sv/1.0\"\n         xmlns:mix=\"http://www.jcp.org/jcr/mix/1.0\"\n         xmlns:jcr=\"http://www.jcp.org/jcr/1.0\"\n         sv:name=\"testnode1\">\n    <sv:property sv:name=\"jcr:primaryType\" sv:type=\"Name\">\n        <sv:value>" + referenceableNt + "</sv:value>\n" + "    </sv:property>\n" + "    <sv:property sv:name=\"jcr:uuid\" sv:type=\"String\">\n" + "        <sv:value>" + uuid + "</sv:value>\n" + "    </sv:property>\n" + "</sv:node>";
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        this.superuser.importXML(this.testRootNode.getPath(), (InputStream)in, 3);
    }

    public void testMixVersionable() throws IOException, RepositoryException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><sv:node sv:name=\"test\" xmlns:mix=\"http://www.jcp.org/jcr/mix/1.0\" xmlns:nt=\"http://www.jcp.org/jcr/nt/1.0\" xmlns:fn_old=\"http://www.w3.org/2004/10/xpath-functions\" xmlns:fn=\"http://www.w3.org/2005/xpath-functions\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:sv=\"http://www.jcp.org/jcr/sv/1.0\" xmlns:rep=\"internal\" xmlns:jcr=\"http://www.jcp.org/jcr/1.0\"><sv:property sv:name=\"jcr:primaryType\" sv:type=\"Name\">   <sv:value>nt:unstructured</sv:value></sv:property><sv:property sv:name=\"jcr:mixinTypes\" sv:type=\"Name\" sv:multiple=\"true\">   <sv:value>mix:versionable</sv:value></sv:property><sv:property sv:name=\"jcr:uuid\" sv:type=\"String\">   <sv:value>75806b92-317f-4cb3-bc3d-ee87a95cf21f</sv:value></sv:property><sv:property sv:name=\"jcr:baseVersion\" sv:type=\"Reference\">   <sv:value>6b91c6e5-1b83-4921-94a1-5d92ca389b3f</sv:value></sv:property><sv:property sv:name=\"jcr:isCheckedOut\" sv:type=\"Boolean\">   <sv:value>true</sv:value></sv:property><sv:property sv:name=\"jcr:predecessors\" sv:type=\"Reference\" sv:multiple=\"true\">   <sv:value>6b91c6e5-1b83-4921-94a1-5d92ca389b3f</sv:value></sv:property><sv:property sv:name=\"jcr:versionHistory\" sv:type=\"Reference\">   <sv:value>99b5ec0f-49cb-4ccf-b9fd-9fba82349420</sv:value></sv:property></sv:node>";
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        this.superuser.importXML(this.testRootNode.getPath(), (InputStream)in, 3);
        this.superuser.save();
        SessionImportTest.assertTrue((String)"test node must be present", (boolean)this.testRootNode.hasNode("test"));
        Node n = this.testRootNode.getNode("test");
        SessionImportTest.assertTrue((String)"node must be mix:versionable", (boolean)n.isNodeType(this.mixVersionable));
        SessionImportTest.assertTrue((String)"node must be mix:referenceable", (boolean)n.isNodeType(this.mixReferenceable));
        SessionImportTest.assertEquals((String)"75806b92-317f-4cb3-bc3d-ee87a95cf21f", (String)n.getUUID());
    }

    private static String getUnknownURI(Session session, String uriHint) throws RepositoryException {
        String uri = uriHint;
        int index = 0;
        List<String> uris = Arrays.asList(session.getWorkspace().getNamespaceRegistry().getURIs());
        while (uris.contains(uri)) {
            uri = uriHint + index;
            ++index;
        }
        return uri;
    }

    public static String getUniquePrefix(Session session) throws RepositoryException {
        return "_pre" + (session.getNamespacePrefixes().length + 1);
    }
}

