/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.security.Privilege;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.SecurityConfig;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.GlobalNameMapper;
import org.apache.jackrabbit.oak.namepath.NameMapper;
import org.apache.jackrabbit.oak.plugins.index.CompositeIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdate;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.reference.ReferenceEditorProvider;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.name.Namespaces;
import org.apache.jackrabbit.oak.plugins.nodetype.TypeEditorProvider;
import org.apache.jackrabbit.oak.plugins.nodetype.write.InitialContent;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeBuilder;
import org.apache.jackrabbit.oak.security.SecurityProviderImpl;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditorProvider;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.upgrade.AsciiArtTicker;
import org.apache.jackrabbit.oak.upgrade.JackrabbitNodeState;
import org.apache.jackrabbit.oak.upgrade.ProgressNotificationEditor;
import org.apache.jackrabbit.oak.upgrade.security.GroupEditorProvider;
import org.apache.jackrabbit.oak.upgrade.security.RestrictionEditorProvider;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueConstraint;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryUpgrade {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryUpgrade.class);
    private final RepositoryContext source;
    private final NodeStore target;
    private boolean copyBinariesByReference = false;

    public static void copy(File source, NodeStore target) throws RepositoryException {
        RepositoryUpgrade.copy(RepositoryConfig.create((File)source), target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(RepositoryConfig source, NodeStore target) throws RepositoryException {
        RepositoryContext context = RepositoryContext.create((RepositoryConfig)source);
        try {
            new RepositoryUpgrade(context, target).copy(null);
        }
        finally {
            context.getRepository().shutdown();
        }
    }

    public RepositoryUpgrade(RepositoryContext source, NodeStore target) {
        this.source = source;
        this.target = target;
    }

    public boolean isCopyBinariesByReference() {
        return this.copyBinariesByReference;
    }

    public void setCopyBinariesByReference(boolean copyBinariesByReference) {
        this.copyBinariesByReference = copyBinariesByReference;
    }

    public void copy(RepositoryInitializer initializer) throws RepositoryException {
        RepositoryConfig config = this.source.getRepositoryConfig();
        logger.info("Copying repository content from {} to Oak", (Object)config.getHomeDir());
        try {
            NodeState base = this.target.getRoot();
            NodeBuilder builder = base.builder();
            String workspaceName = this.source.getRepositoryConfig().getDefaultWorkspaceName();
            SecurityProviderImpl security = new SecurityProviderImpl(this.mapSecurityConfig(config.getSecurityConfig()));
            new InitialContent().initialize(builder);
            if (initializer != null) {
                initializer.initialize(builder);
            }
            for (SecurityConfiguration sc : security.getConfigurations()) {
                sc.getRepositoryInitializer().initialize(builder);
            }
            for (SecurityConfiguration sc : security.getConfigurations()) {
                sc.getWorkspaceInitializer().initialize(builder, workspaceName);
            }
            HashBiMap uriToPrefix = HashBiMap.create();
            HashMap idxToPrefix = Maps.newHashMap();
            this.copyNamespaces(builder, (Map<String, String>)uriToPrefix, idxToPrefix);
            this.copyNodeTypes(builder, (Map<String, String>)uriToPrefix.inverse());
            this.copyCustomPrivileges(builder);
            new TypeEditorProvider(false).getRootEditor(base, builder.getNodeState(), builder, null);
            HashMap versionablePaths = Maps.newHashMap();
            NodeState root = builder.getNodeState();
            this.copyWorkspace(builder, root, workspaceName, (Map<String, String>)uriToPrefix, idxToPrefix, versionablePaths);
            this.copyVersionStore(builder, root, workspaceName, (Map<String, String>)uriToPrefix, idxToPrefix, versionablePaths);
            logger.info("Applying default commit hooks");
            ArrayList hooks = Lists.newArrayList();
            UserConfiguration userConf = (UserConfiguration)security.getConfiguration(UserConfiguration.class);
            String groupsPath = (String)userConf.getParameters().getConfigValue("groupsPath", (Object)"/rep:security/rep:authorizables/rep:groups");
            hooks.add(new EditorHook((EditorProvider)new CompositeEditorProvider(new EditorProvider[]{new RestrictionEditorProvider(), new GroupEditorProvider(groupsPath)})));
            for (SecurityConfiguration sc : security.getConfigurations()) {
                hooks.addAll(sc.getCommitHooks(workspaceName));
            }
            hooks.add(new EditorHook((EditorProvider)new CompositeEditorProvider(new EditorProvider[]{RepositoryUpgrade.createTypeEditorProvider(), RepositoryUpgrade.createIndexEditorProvider()})));
            this.target.merge(builder, (CommitHook)new LoggingCompositeHook(hooks), CommitInfo.EMPTY);
        }
        catch (Exception e) {
            throw new RepositoryException("Failed to copy content", (Throwable)e);
        }
    }

    private static EditorProvider createTypeEditorProvider() {
        return new EditorProvider(){

            public Editor getRootEditor(NodeState before, NodeState after, NodeBuilder builder, CommitInfo info) throws CommitFailedException {
                Editor rootEditor = new TypeEditorProvider(false).getRootEditor(before, after, builder, info);
                return ProgressNotificationEditor.wrap(rootEditor, logger, "Checking node types:");
            }

            public String toString() {
                return "TypeEditorProvider";
            }
        };
    }

    private static EditorProvider createIndexEditorProvider() {
        final AsciiArtTicker ticker = new AsciiArtTicker();
        return new EditorProvider(){

            public Editor getRootEditor(NodeState before, NodeState after, NodeBuilder builder, CommitInfo info) {
                CompositeIndexEditorProvider editorProviders = new CompositeIndexEditorProvider(new IndexEditorProvider[]{new ReferenceEditorProvider(), new PropertyIndexEditorProvider()});
                return new IndexUpdate((IndexEditorProvider)editorProviders, null, after, builder, new IndexUpdateCallback(){
                    String progress = "Updating indexes ";
                    long t0;

                    public void indexUpdate() {
                        long t = System.currentTimeMillis();
                        if (t - this.t0 > 2000L) {
                            logger.info("{} {}", (Object)this.progress, (Object)ticker.tick());
                            this.t0 = t;
                        }
                    }
                });
            }

            public String toString() {
                return "IndexEditorProvider";
            }
        };
    }

    protected ConfigurationParameters mapSecurityConfig(SecurityConfig config) {
        ConfigurationParameters loginConfig = this.mapConfigurationParameters((BeanConfig)config.getLoginModuleConfig(), "adminId", "adminId", "anonymousId", "anonymousId");
        ConfigurationParameters userConfig = this.mapConfigurationParameters((BeanConfig)config.getSecurityManagerConfig().getUserManagerConfig(), "usersPath", "usersPath", "groupsPath", "groupsPath", "defaultDepth", "defaultDepth", "passwordHashAlgorithm", "passwordHashAlgorithm", "passwordHashIterations", "passwordHashIterations");
        return ConfigurationParameters.of((Map)ImmutableMap.of((Object)"org.apache.jackrabbit.oak.user", (Object)ConfigurationParameters.of((ConfigurationParameters[])new ConfigurationParameters[]{loginConfig, userConfig})));
    }

    protected ConfigurationParameters mapConfigurationParameters(BeanConfig config, String ... mapping) {
        HashMap map = Maps.newHashMap();
        if (config != null) {
            Properties properties = config.getParameters();
            int i = 0;
            while (i + 1 < mapping.length) {
                String value = properties.getProperty(mapping[i]);
                if (value != null) {
                    map.put(mapping[i + 1], value);
                }
                i += 2;
            }
        }
        return ConfigurationParameters.of((Map)map);
    }

    private String getOakName(Name name) throws NamespaceException {
        String uri = name.getNamespaceURI();
        String local = name.getLocalName();
        if (uri == null || uri.isEmpty()) {
            return local;
        }
        return this.source.getNamespaceRegistry().getPrefix(uri) + ":" + local;
    }

    private void copyNamespaces(NodeBuilder root, Map<String, String> uriToPrefix, Map<Integer, String> idxToPrefix) throws RepositoryException {
        NodeBuilder system = root.child("jcr:system");
        NodeBuilder namespaces = system.child("rep:namespaces");
        Properties registry = this.loadProperties("/namespaces/ns_reg.properties");
        Properties indexes = this.loadProperties("/namespaces/ns_idx.properties");
        for (String prefixHint : registry.stringPropertyNames()) {
            Integer idx;
            String uri = registry.getProperty(prefixHint);
            String prefix = ".empty.key".equals(prefixHint) ? "" : Namespaces.addCustomMapping((NodeBuilder)namespaces, (String)uri, (String)prefixHint);
            String index = null;
            if (uri.isEmpty()) {
                index = indexes.getProperty(".empty.key");
            }
            if (index == null) {
                index = indexes.getProperty(uri);
            }
            if (index != null) {
                idx = Integer.decode(index);
            } else {
                int i = 0;
                while (idxToPrefix.containsKey(idx = Integer.valueOf(uri.hashCode() + i++ & 0xFFFFFF))) {
                }
            }
            Preconditions.checkState((uriToPrefix.put(uri, prefix) == null ? 1 : 0) != 0);
            Preconditions.checkState((idxToPrefix.put(idx, prefix) == null ? 1 : 0) != 0);
        }
        Namespaces.buildIndexNode((NodeBuilder)namespaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(String path) throws RepositoryException {
        Properties properties;
        block6: {
            properties = new Properties();
            FileSystem filesystem = this.source.getFileSystem();
            try {
                if (!filesystem.exists(path)) break block6;
                InputStream stream = filesystem.getInputStream(path);
                try {
                    properties.load(stream);
                }
                finally {
                    stream.close();
                }
            }
            catch (FileSystemException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return properties;
    }

    private void copyCustomPrivileges(NodeBuilder root) {
        PrivilegeRegistry registry = this.source.getPrivilegeRegistry();
        NodeBuilder privileges = root.child("jcr:system").child("rep:privileges");
        privileges.setProperty("jcr:primaryType", (Object)"rep:Privileges", Type.NAME);
        PrivilegeBits next = PrivilegeBits.NEXT_AFTER_BUILT_INS;
        logger.info("Copying registered privileges");
        for (Privilege privilege : registry.getRegisteredPrivileges()) {
            PrivilegeBits bits;
            Privilege[] aggregate;
            String name = privilege.getName();
            if (PrivilegeBits.BUILT_IN.containsKey(name) || "jcr:all".equals(name)) continue;
            NodeBuilder def = privileges.child(name);
            def.setProperty("jcr:primaryType", (Object)"rep:Privilege", Type.NAME);
            if (privilege.isAbstract()) {
                def.setProperty("rep:isAbstract", (Object)true);
            }
            if ((aggregate = privilege.getDeclaredAggregatePrivileges()).length > 0) {
                ArrayList names = Lists.newArrayListWithCapacity((int)aggregate.length);
                for (Privilege p : aggregate) {
                    names.add(p.getName());
                }
                def.setProperty("rep:aggregates", (Object)names, Type.NAMES);
            }
            if ((bits = (PrivilegeBits)PrivilegeBits.BUILT_IN.get(name)) != null) {
                def.setProperty(bits.asPropertyState("rep:bits"));
                continue;
            }
            if (aggregate.length != 0) continue;
            bits = next;
            next = next.nextBits();
            def.setProperty(bits.asPropertyState("rep:bits"));
        }
        privileges.setProperty(next.asPropertyState("rep:next"));
        for (String name : privileges.getChildNodeNames()) {
            RepositoryUpgrade.resolvePrivilegeBits(privileges, name);
        }
    }

    private static PrivilegeBits resolvePrivilegeBits(NodeBuilder privileges, String name) {
        NodeBuilder def = privileges.getChildNode(name);
        PropertyState b = def.getProperty("rep:bits");
        if (b != null) {
            return PrivilegeBits.getInstance((PropertyState)b);
        }
        PrivilegeBits bits = PrivilegeBits.getInstance();
        for (String n : def.getNames("rep:aggregates")) {
            bits.add(RepositoryUpgrade.resolvePrivilegeBits(privileges, n));
        }
        def.setProperty(bits.asPropertyState("rep:bits"));
        return bits;
    }

    private void copyNodeTypes(NodeBuilder root, Map<String, String> prefixToUri) throws RepositoryException {
        NodeTypeRegistry sourceRegistry = this.source.getNodeTypeRegistry();
        NodeBuilder system = root.child("jcr:system");
        NodeBuilder types = system.child("jcr:nodeTypes");
        logger.info("Copying registered node types");
        for (Name name : sourceRegistry.getRegisteredNodeTypes()) {
            String oakName = this.getOakName(name);
            if (types.hasChildNode(oakName)) continue;
            QNodeTypeDefinition def = sourceRegistry.getNodeTypeDef(name);
            NodeBuilder type = types.child(oakName);
            this.copyNodeType(def, type, prefixToUri);
        }
    }

    private void copyNodeType(QNodeTypeDefinition def, NodeBuilder builder, Map<String, String> prefixToUri) throws RepositoryException {
        builder.setProperty("jcr:primaryType", (Object)"nt:nodeType", Type.NAME);
        builder.setProperty("jcr:nodeTypeName", (Object)this.getOakName(def.getName()), Type.NAME);
        Name[] supertypes = def.getSupertypes();
        if (supertypes != null && supertypes.length > 0) {
            ArrayList names = Lists.newArrayListWithCapacity((int)supertypes.length);
            for (Name supertype : supertypes) {
                names.add(this.getOakName(supertype));
            }
            builder.setProperty("jcr:supertypes", (Object)names, Type.NAMES);
        }
        builder.setProperty("jcr:isAbstract", (Object)def.isAbstract());
        builder.setProperty("jcr:isQueryable", (Object)def.isQueryable());
        builder.setProperty("jcr:isMixin", (Object)def.isMixin());
        builder.setProperty("jcr:hasOrderableChildNodes", (Object)def.hasOrderableChildNodes());
        Name primary = def.getPrimaryItemName();
        if (primary != null) {
            builder.setProperty("jcr:primaryItemName", (Object)this.getOakName(primary), Type.NAME);
        }
        QPropertyDefinition[] properties = def.getPropertyDefs();
        for (int i = 0; i < properties.length; ++i) {
            String name = "jcr:propertyDefinition[" + (i + 1) + ']';
            this.copyPropertyDefinition(properties[i], builder.child(name), prefixToUri);
        }
        QNodeDefinition[] childNodes = def.getChildNodeDefs();
        for (int i = 0; i < childNodes.length; ++i) {
            String name = "jcr:childNodeDefinition[" + (i + 1) + ']';
            this.copyChildNodeDefinition(childNodes[i], builder.child(name));
        }
    }

    private void copyPropertyDefinition(QPropertyDefinition def, NodeBuilder builder, Map<String, String> prefixToUri) throws RepositoryException {
        QValue[] qValues;
        builder.setProperty("jcr:primaryType", (Object)"nt:propertyDefinition", Type.NAME);
        this.copyItemDefinition((QItemDefinition)def, builder);
        builder.setProperty("jcr:requiredType", (Object)Type.fromTag((int)def.getRequiredType(), (boolean)false).toString());
        QValueConstraint[] constraints = def.getValueConstraints();
        if (constraints != null && constraints.length > 0) {
            ArrayList strings = Lists.newArrayListWithCapacity((int)constraints.length);
            for (QValueConstraint constraint : constraints) {
                strings.add(constraint.getString());
            }
            builder.setProperty("jcr:valueConstraints", (Object)strings, Type.STRINGS);
        }
        if ((qValues = def.getDefaultValues()) != null) {
            RepositoryUpgrade.copyDefaultValues(qValues, builder, (NameMapper)new GlobalNameMapper(prefixToUri));
        }
        builder.setProperty("jcr:multiple", (Object)def.isMultiple());
        List<String> operators = Arrays.asList(def.getAvailableQueryOperators());
        builder.setProperty("jcr:availableQueryOperators", operators, Type.NAMES);
        builder.setProperty("jcr:isFullTextSearchable", (Object)def.isFullTextSearchable());
        builder.setProperty("jcr:isQueryOrderable", (Object)def.isQueryOrderable());
    }

    private static void copyDefaultValues(QValue[] qValues, NodeBuilder builder, NameMapper nameMapper) throws RepositoryException {
        if (qValues.length != 0) {
            int type = qValues[0].getType();
            switch (type) {
                case 1: {
                    ArrayList strings = Lists.newArrayListWithCapacity((int)qValues.length);
                    for (QValue qValue : qValues) {
                        strings.add(qValue.getString());
                    }
                    builder.setProperty(PropertyStates.createProperty((String)"jcr:defaultValues", (Object)strings, (Type)Type.STRINGS));
                    return;
                }
                case 3: {
                    ArrayList longs = Lists.newArrayListWithCapacity((int)qValues.length);
                    for (QValue qValue : qValues) {
                        longs.add(qValue.getLong());
                    }
                    builder.setProperty(PropertyStates.createProperty((String)"jcr:defaultValues", (Object)longs, (Type)Type.LONGS));
                    return;
                }
                case 4: {
                    ArrayList doubles = Lists.newArrayListWithCapacity((int)qValues.length);
                    for (QValue qValue : qValues) {
                        doubles.add(qValue.getDouble());
                    }
                    builder.setProperty(PropertyStates.createProperty((String)"jcr:defaultValues", (Object)doubles, (Type)Type.DOUBLES));
                    return;
                }
                case 6: {
                    ArrayList booleans = Lists.newArrayListWithCapacity((int)qValues.length);
                    for (QValue qValue : qValues) {
                        booleans.add(qValue.getBoolean());
                    }
                    builder.setProperty(PropertyStates.createProperty((String)"jcr:defaultValues", (Object)booleans, (Type)Type.BOOLEANS));
                    return;
                }
                case 7: {
                    ArrayList names = Lists.newArrayListWithCapacity((int)qValues.length);
                    for (QValue qValue : qValues) {
                        names.add(nameMapper.getOakName(qValue.getName().toString()));
                    }
                    builder.setProperty(PropertyStates.createProperty((String)"jcr:defaultValues", (Object)names, (Type)Type.NAMES));
                    return;
                }
                case 8: {
                    ArrayList paths = Lists.newArrayListWithCapacity((int)qValues.length);
                    for (QValue qValue : qValues) {
                        paths.add(RepositoryUpgrade.getOakPath(qValue.getPath(), nameMapper));
                    }
                    builder.setProperty(PropertyStates.createProperty((String)"jcr:defaultValues", (Object)paths, (Type)Type.PATHS));
                    return;
                }
                case 12: {
                    ArrayList decimals = Lists.newArrayListWithCapacity((int)qValues.length);
                    for (QValue qValue : qValues) {
                        decimals.add(qValue.getDecimal());
                    }
                    builder.setProperty(PropertyStates.createProperty((String)"jcr:defaultValues", (Object)decimals, (Type)Type.DECIMALS));
                    return;
                }
                case 5: 
                case 11: {
                    ArrayList values = Lists.newArrayListWithCapacity((int)qValues.length);
                    for (QValue qValue : qValues) {
                        values.add(qValue.getString());
                    }
                    builder.setProperty(PropertyStates.createProperty((String)"jcr:defaultValues", (Object)values, (Type)Type.fromTag((int)type, (boolean)true)));
                    return;
                }
            }
            throw new UnsupportedRepositoryOperationException("Cannot copy default value of type " + Type.fromTag((int)type, (boolean)true));
        }
        builder.setProperty("jcr:defaultValues", Collections.emptyList(), Type.STRINGS);
    }

    private static String getOakPath(Path path, NameMapper nameMapper) throws RepositoryException {
        StringBuilder oakPath = new StringBuilder();
        String sep = "";
        for (Path.Element element : path.getElements()) {
            if (element.denotesRoot()) {
                oakPath.append('/');
                continue;
            }
            if (element.denotesName()) {
                oakPath.append(sep).append(nameMapper.getOakName(element.getString()));
            } else if (element.denotesCurrent()) {
                oakPath.append(sep).append('.');
            } else if (element.denotesParent()) {
                oakPath.append(sep).append("..");
            } else {
                throw new UnsupportedRepositoryOperationException("Cannot copy default value " + path);
            }
            sep = "/";
        }
        return oakPath.toString();
    }

    private void copyChildNodeDefinition(QNodeDefinition def, NodeBuilder builder) throws NamespaceException {
        builder.setProperty("jcr:primaryType", (Object)"nt:childNodeDefinition", Type.NAME);
        this.copyItemDefinition((QItemDefinition)def, builder);
        Name[] types = def.getRequiredPrimaryTypes();
        ArrayList names = Lists.newArrayListWithCapacity((int)types.length);
        for (Name type : types) {
            names.add(this.getOakName(type));
        }
        builder.setProperty("jcr:requiredPrimaryTypes", (Object)names, Type.NAMES);
        Name type = def.getDefaultPrimaryType();
        if (type != null) {
            builder.setProperty("jcr:defaultPrimaryType", (Object)this.getOakName(type), Type.NAME);
        }
        builder.setProperty("jcr:sameNameSiblings", (Object)def.allowsSameNameSiblings());
    }

    private void copyItemDefinition(QItemDefinition def, NodeBuilder builder) throws NamespaceException {
        Name name = def.getName();
        if (name != null && !name.equals(NameConstants.ANY_NAME)) {
            builder.setProperty("jcr:name", (Object)this.getOakName(name), Type.NAME);
        }
        builder.setProperty("jcr:autoCreated", (Object)def.isAutoCreated());
        builder.setProperty("jcr:mandatory", (Object)def.isMandatory());
        builder.setProperty("jcr:onParentVersion", (Object)OnParentVersionAction.nameFromValue((int)def.getOnParentVersion()));
        builder.setProperty("jcr:protected", (Object)def.isProtected());
    }

    private void copyVersionStore(NodeBuilder builder, NodeState root, String workspaceName, Map<String, String> uriToPrefix, Map<Integer, String> idxToPrefix, Map<String, String> versionablePaths) throws RepositoryException, IOException {
        PersistenceManager pm = this.source.getInternalVersionManager().getPersistenceManager();
        NodeBuilder system = builder.child("jcr:system");
        logger.info("Copying version histories");
        this.copyState(system, "jcr:versionStorage", (NodeState)new JackrabbitNodeState(pm, root, uriToPrefix, RepositoryImpl.VERSION_STORAGE_NODE_ID, "/jcr:system/jcr:versionStorage", workspaceName, versionablePaths, this.copyBinariesByReference));
        logger.info("Copying activities");
        this.copyState(system, "jcr:activities", (NodeState)new JackrabbitNodeState(pm, root, uriToPrefix, RepositoryImpl.ACTIVITIES_NODE_ID, "/jcr:system/jcr:activities", workspaceName, versionablePaths, this.copyBinariesByReference));
    }

    private String copyWorkspace(NodeBuilder builder, NodeState root, String workspaceName, Map<String, String> uriToPrefix, Map<Integer, String> idxToPrefix, Map<String, String> versionablePaths) throws RepositoryException, IOException {
        logger.info("Copying workspace {}", (Object)workspaceName);
        PersistenceManager pm = this.source.getWorkspaceInfo(workspaceName).getPersistenceManager();
        JackrabbitNodeState state = new JackrabbitNodeState(pm, root, uriToPrefix, RepositoryImpl.ROOT_NODE_ID, "/", workspaceName, versionablePaths, this.copyBinariesByReference);
        for (PropertyState property : state.getProperties()) {
            builder.setProperty(property);
        }
        for (ChildNodeEntry child : state.getChildNodeEntries()) {
            String childName = child.getName();
            if ("jcr:system".equals(childName)) continue;
            logger.info("Copying subtree /{}", (Object)childName);
            this.copyState(builder, childName, child.getNodeState());
        }
        return workspaceName;
    }

    private void copyState(NodeBuilder parent, String name, NodeState state) {
        if (parent instanceof SegmentNodeBuilder) {
            parent.setChildNode(name, state);
        } else {
            this.setChildNode(parent, name, state);
        }
    }

    private void setChildNode(NodeBuilder parent, String name, NodeState state) {
        if (name.length() > 37 && name.getBytes(Charsets.UTF_8).length > 150) {
            logger.warn("Node name too long. Skipping {}", (Object)state);
            return;
        }
        NodeBuilder builder = parent.setChildNode(name);
        for (PropertyState property : state.getProperties()) {
            builder.setProperty(property);
        }
        for (ChildNodeEntry child : state.getChildNodeEntries()) {
            this.setChildNode(builder, child.getName(), child.getNodeState());
        }
    }

    private static class LoggingCompositeHook
    implements CommitHook {
        private final Collection<CommitHook> hooks;

        public LoggingCompositeHook(Collection<CommitHook> hooks) {
            this.hooks = hooks;
        }

        @Nonnull
        public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
            NodeState newState = after;
            Stopwatch watch = Stopwatch.createStarted();
            for (CommitHook hook : this.hooks) {
                logger.info("Processing commit via {}", (Object)hook);
                newState = hook.processCommit(before, newState, info);
                logger.info("Commit hook {} processed commit in {}", (Object)hook, (Object)watch);
                watch.reset().start();
            }
            return newState;
        }
    }
}

