/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade;

import com.google.common.base.Strings;
import org.apache.jackrabbit.oak.upgrade.ProgressTicker;

public class SimpleTicker
implements ProgressTicker {
    private final int maxTicks;
    private int dotCount;
    private boolean decreasing;

    public SimpleTicker(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    @Override
    public String tick() {
        int n;
        if (this.decreasing) {
            int n2 = this.dotCount;
            n = n2;
            this.dotCount = n2 - 1;
        } else {
            int n3 = this.dotCount;
            n = n3;
            this.dotCount = n3 + 1;
        }
        int noOfDots = n;
        if (this.dotCount == 0) {
            this.decreasing = false;
        }
        if (this.dotCount == this.maxTicks) {
            this.decreasing = true;
        }
        return Strings.repeat((String)".", (int)noOfDots);
    }
}

