/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.evaluation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.evaluation.RepresentativePointsMapper;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ClusterEvaluator.class);
    private final Map<Integer, List<VectorWritable>> representativePoints;
    private final List<Cluster> clusters;
    private final DistanceMeasure measure;
    private boolean pruned;

    public ClusterEvaluator(Map<Integer, List<VectorWritable>> representativePoints, List<Cluster> clusters, DistanceMeasure measure) {
        this.representativePoints = representativePoints;
        this.clusters = clusters;
        this.measure = measure;
    }

    public ClusterEvaluator(Configuration conf, Path clustersIn) {
        this.measure = (DistanceMeasure)ClassUtils.instantiateAs((String)conf.get("org.apache.mahout.clustering.measure"), DistanceMeasure.class);
        this.representativePoints = RepresentativePointsMapper.getRepresentativePoints(conf);
        this.clusters = ClusterEvaluator.loadClusters(conf, clustersIn);
    }

    private static List<Cluster> loadClusters(Configuration conf, Path clustersIn) {
        ArrayList clusters = Lists.newArrayList();
        for (ClusterWritable clusterWritable : new SequenceFileDirValueIterable(clustersIn, PathType.LIST, PathFilters.logsCRCFilter(), conf)) {
            Cluster cluster = clusterWritable.getValue();
            clusters.add(cluster);
        }
        return clusters;
    }

    private boolean invalidCluster(Cluster clusterI) {
        List<VectorWritable> repPts = this.representativePoints.get(clusterI.getId());
        if (repPts.size() < 2) {
            return true;
        }
        for (VectorWritable vw : repPts) {
            Vector vector = vw.get();
            if (vector.equals(clusterI.getCenter())) continue;
            return false;
        }
        return true;
    }

    private void pruneInvalidClusters() {
        if (this.pruned) {
            return;
        }
        Iterator<Cluster> it = this.clusters.iterator();
        while (it.hasNext()) {
            Cluster cluster = it.next();
            if (!this.invalidCluster(cluster)) continue;
            log.info("Pruning cluster Id={}", (Object)cluster.getId());
            it.remove();
            this.representativePoints.remove(cluster.getId());
        }
        this.pruned = true;
    }

    public double interClusterDensity() {
        this.pruneInvalidClusters();
        double max = 0.0;
        double min = Double.MAX_VALUE;
        double sum = 0.0;
        int count = 0;
        for (int i = 0; i < this.clusters.size(); ++i) {
            Cluster clusterI = this.clusters.get(i);
            for (int j = i + 1; j < this.clusters.size(); ++j) {
                Cluster clusterJ = this.clusters.get(j);
                double d = this.measure.distance(clusterI.getCenter(), clusterJ.getCenter());
                min = Math.min(d, min);
                max = Math.max(d, max);
                sum += d;
                ++count;
            }
        }
        double density = (sum / (double)count - min) / (max - min);
        log.info("Inter-Cluster Density = {}", (Object)density);
        return density;
    }

    public double intraClusterDensity() {
        this.pruneInvalidClusters();
        double avgDensity = 0.0;
        for (Cluster cluster : this.clusters) {
            int count = 0;
            double max = 0.0;
            double min = Double.MAX_VALUE;
            double sum = 0.0;
            List<VectorWritable> repPoints = this.representativePoints.get(cluster.getId());
            for (int i = 0; i < repPoints.size(); ++i) {
                for (int j = i + 1; j < repPoints.size(); ++j) {
                    double d = this.measure.distance(repPoints.get(i).get(), repPoints.get(j).get());
                    min = Math.min(d, min);
                    max = Math.max(d, max);
                    sum += d;
                    ++count;
                }
            }
            double density = (sum / (double)count - min) / (max - min);
            avgDensity += density;
            log.info("Intra-Cluster Density[{}] = {}", (Object)cluster.getId(), (Object)density);
        }
        avgDensity = this.clusters.isEmpty() ? 0.0 : avgDensity / (double)this.clusters.size();
        log.info("Intra-Cluster Density = {}", (Object)avgDensity);
        return avgDensity;
    }
}

