/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text.wikipedia;

import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.wikipedia.WikipediaTokenizer;
import org.apache.lucene.util.Version;

public class WikipediaAnalyzer
extends StopwordAnalyzerBase {
    public WikipediaAnalyzer() {
        super(Version.LUCENE_31, StopAnalyzer.ENGLISH_STOP_WORDS_SET);
    }

    public WikipediaAnalyzer(Set<?> stopSet) {
        super(Version.LUCENE_31, stopSet);
    }

    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        WikipediaTokenizer tokenizer = new WikipediaTokenizer(reader);
        StandardFilter result = new StandardFilter(Version.LUCENE_31, (TokenStream)tokenizer);
        result = new LowerCaseFilter(Version.LUCENE_31, (TokenStream)result);
        result = new StopFilter(Version.LUCENE_31, (TokenStream)result, (Set)this.stopwords);
        return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)result);
    }
}

