/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.lucene;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.mahout.utils.vectors.TermEntry;
import org.apache.mahout.utils.vectors.TermInfo;

public class CachedTermInfo
implements TermInfo {
    private final Map<String, TermEntry> termEntries;
    private final String field;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedTermInfo(IndexReader reader, String field, int minDf, int maxDfPercent) throws IOException {
        this.field = field;
        TermEnum te = reader.terms(new Term(field, ""));
        try {
            Term term;
            int numDocs = reader.numDocs();
            double percent = (double)(numDocs * maxDfPercent) / 100.0;
            this.termEntries = new LinkedHashMap<String, TermEntry>();
            int count = 0;
            while ((term = te.term()) != null) {
                if (!term.field().equals(field)) {
                } else {
                    int df = te.docFreq();
                    if (df >= minDf && !((double)df > percent)) {
                        TermEntry entry = new TermEntry(term.text(), count++, df);
                        this.termEntries.put(entry.getTerm(), entry);
                    }
                    if (te.next()) continue;
                }
                break;
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)te);
        }
    }

    @Override
    public int totalTerms(String field) {
        return this.termEntries.size();
    }

    @Override
    public TermEntry getTermEntry(String field, String term) {
        if (!this.field.equals(field)) {
            return null;
        }
        return this.termEntries.get(term);
    }

    @Override
    public Iterator<TermEntry> getAllEntries() {
        return this.termEntries.values().iterator();
    }
}

