/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Iterator;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.DoubleFunction;

public class NamedVector
implements Vector {
    private Vector delegate;
    private String name;

    public NamedVector() {
    }

    public NamedVector(NamedVector other) {
        this.delegate = other.getDelegate();
        this.name = other.getName();
    }

    public NamedVector(Vector delegate, String name) {
        if (delegate == null || name == null) {
            throw new IllegalArgumentException();
        }
        this.delegate = delegate;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Vector getDelegate() {
        return this.delegate;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object other) {
        return this.delegate.equals(other);
    }

    @Override
    public NamedVector clone() {
        return new NamedVector(this.delegate.clone(), this.name);
    }

    @Override
    public String asFormatString() {
        return this.toString();
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append(this.name).append(':').append(this.delegate.toString());
        return bldr.toString();
    }

    @Override
    public Vector assign(double value) {
        return this.delegate.assign(value);
    }

    @Override
    public Vector assign(double[] values) {
        return this.delegate.assign(values);
    }

    @Override
    public Vector assign(Vector other) {
        return this.delegate.assign(other);
    }

    @Override
    public Vector assign(DoubleFunction function) {
        return this.delegate.assign(function);
    }

    @Override
    public Vector assign(Vector other, DoubleDoubleFunction function) {
        return this.delegate.assign(other, function);
    }

    @Override
    public Vector assign(DoubleDoubleFunction f, double y) {
        return this.delegate.assign(f, y);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isDense() {
        return this.delegate.isDense();
    }

    @Override
    public boolean isSequentialAccess() {
        return this.delegate.isSequentialAccess();
    }

    @Override
    public Iterator<Vector.Element> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Iterator<Vector.Element> iterateNonZero() {
        return this.delegate.iterateNonZero();
    }

    @Override
    public Vector.Element getElement(int index) {
        return this.delegate.getElement(index);
    }

    @Override
    public Vector divide(double x) {
        return this.delegate.divide(x);
    }

    @Override
    public double dot(Vector x) {
        return this.delegate.dot(x);
    }

    @Override
    public double get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public double getQuick(int index) {
        return this.delegate.getQuick(index);
    }

    @Override
    public NamedVector like() {
        return new NamedVector(this.delegate.like(), this.name);
    }

    @Override
    public Vector minus(Vector x) {
        return this.delegate.minus(x);
    }

    @Override
    public Vector normalize() {
        return this.delegate.normalize();
    }

    @Override
    public Vector normalize(double power) {
        return this.delegate.normalize(power);
    }

    @Override
    public Vector logNormalize() {
        return this.delegate.logNormalize();
    }

    @Override
    public Vector logNormalize(double power) {
        return this.delegate.logNormalize(power);
    }

    @Override
    public double norm(double power) {
        return this.delegate.norm(power);
    }

    @Override
    public double maxValue() {
        return this.delegate.maxValue();
    }

    @Override
    public int maxValueIndex() {
        return this.delegate.maxValueIndex();
    }

    @Override
    public double minValue() {
        return this.delegate.minValue();
    }

    @Override
    public int minValueIndex() {
        return this.delegate.minValueIndex();
    }

    @Override
    public Vector plus(double x) {
        return this.delegate.plus(x);
    }

    @Override
    public Vector plus(Vector x) {
        return this.delegate.plus(x);
    }

    @Override
    public void set(int index, double value) {
        this.delegate.set(index, value);
    }

    @Override
    public void setQuick(int index, double value) {
        this.delegate.setQuick(index, value);
    }

    @Override
    public int getNumNondefaultElements() {
        return this.delegate.getNumNondefaultElements();
    }

    @Override
    public Vector times(double x) {
        return this.delegate.times(x);
    }

    @Override
    public Vector times(Vector x) {
        return this.delegate.times(x);
    }

    @Override
    public Vector viewPart(int offset, int length) {
        return this.delegate.viewPart(offset, length);
    }

    @Override
    public double zSum() {
        return this.delegate.zSum();
    }

    @Override
    public Matrix cross(Vector other) {
        return this.delegate.cross(other);
    }

    @Override
    public double aggregate(DoubleDoubleFunction aggregator, DoubleFunction map) {
        return this.delegate.aggregate(aggregator, map);
    }

    @Override
    public double aggregate(Vector other, DoubleDoubleFunction aggregator, DoubleDoubleFunction combiner) {
        return this.delegate.aggregate(other, aggregator, combiner);
    }

    @Override
    public double getLengthSquared() {
        return this.delegate.getLengthSquared();
    }

    @Override
    public double getDistanceSquared(Vector v) {
        return this.delegate.getDistanceSquared(v);
    }
}

