/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.matrix.impl;

import org.apache.mahout.math.matrix.DoubleMatrix1D;
import org.apache.mahout.math.matrix.DoubleMatrix2D;

class WrapperDoubleMatrix1D
extends DoubleMatrix1D {
    private final DoubleMatrix1D content;

    WrapperDoubleMatrix1D(DoubleMatrix1D newContent) {
        if (newContent != null) {
            this.setUp(newContent.size());
        }
        this.content = newContent;
    }

    @Override
    protected DoubleMatrix1D getContent() {
        return this.content;
    }

    @Override
    public double getQuick(int index) {
        return this.content.getQuick(index);
    }

    @Override
    public DoubleMatrix1D like(int size) {
        return this.content.like(size);
    }

    @Override
    public DoubleMatrix2D like2D(int rows, int columns) {
        return this.content.like2D(rows, columns);
    }

    @Override
    public void setQuick(int index, double value) {
        this.content.setQuick(index, value);
    }

    @Override
    public DoubleMatrix1D viewPart(final int index, int width) {
        this.checkRange(index, width);
        WrapperDoubleMatrix1D view = new WrapperDoubleMatrix1D(this){

            @Override
            public double getQuick(int i) {
                return WrapperDoubleMatrix1D.this.content.get(index + i);
            }

            @Override
            public void setQuick(int i, double value) {
                WrapperDoubleMatrix1D.this.content.set(index + i, value);
            }
        };
        view.size = width;
        return view;
    }

    @Override
    protected DoubleMatrix1D viewSelectionLike(int[] offsets) {
        throw new UnsupportedOperationException();
    }
}

