/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import java.io.IOException;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.cf.taste.hadoop.EntityPrefWritable;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public final class ToUserVectorsReducer
extends Reducer<VarLongWritable, VarLongWritable, VarLongWritable, VectorWritable> {
    public static final String MIN_PREFERENCES_PER_USER = ToUserVectorsReducer.class.getName() + ".minPreferencesPerUser";
    private int minPreferences;
    private final VectorWritable userVectorWritable = new VectorWritable();

    protected void setup(Reducer.Context ctx) throws IOException, InterruptedException {
        super.setup(ctx);
        this.minPreferences = ctx.getConfiguration().getInt(MIN_PREFERENCES_PER_USER, 1);
    }

    protected void reduce(VarLongWritable userID, Iterable<VarLongWritable> itemPrefs, Reducer.Context context) throws IOException, InterruptedException {
        RandomAccessSparseVector userVector = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        for (VarLongWritable itemPref : itemPrefs) {
            int index = TasteHadoopUtils.idToIndex(itemPref.get());
            float value = itemPref instanceof EntityPrefWritable ? ((EntityPrefWritable)itemPref).getPrefValue() : 1.0f;
            userVector.set(index, (double)value);
        }
        if (userVector.getNumNondefaultElements() >= this.minPreferences) {
            this.userVectorWritable.set((Vector)userVector);
            this.userVectorWritable.setWritesLaxPrecision(true);
            context.getCounter((Enum)Counters.USERS).increment(1L);
            context.write((Object)userID, (Object)this.userVectorWritable);
        }
    }

    public static enum Counters {
        USERS;

    }
}

