/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.mapreduce.inmem;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.classifier.df.DFUtils;
import org.apache.mahout.classifier.df.DecisionForest;
import org.apache.mahout.classifier.df.builder.TreeBuilder;
import org.apache.mahout.classifier.df.mapreduce.Builder;
import org.apache.mahout.classifier.df.mapreduce.MapredOutput;
import org.apache.mahout.classifier.df.mapreduce.inmem.InMemInputFormat;
import org.apache.mahout.classifier.df.mapreduce.inmem.InMemMapper;
import org.apache.mahout.classifier.df.node.Node;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;

public class InMemBuilder
extends Builder {
    public InMemBuilder(TreeBuilder treeBuilder, Path dataPath, Path datasetPath, Long seed, Configuration conf) {
        super(treeBuilder, dataPath, datasetPath, seed, conf);
    }

    public InMemBuilder(TreeBuilder treeBuilder, Path dataPath, Path datasetPath) {
        this(treeBuilder, dataPath, datasetPath, null, new Configuration());
    }

    @Override
    protected void configureJob(Job job) throws IOException {
        Configuration conf = job.getConfiguration();
        job.setJarByClass(InMemBuilder.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)this.getOutputPath(conf));
        DistributedCache.addCacheFile((URI)this.getDataPath().toUri(), (Configuration)conf);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(MapredOutput.class);
        job.setMapperClass(InMemMapper.class);
        job.setNumReduceTasks(0);
        job.setInputFormatClass(InMemInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
    }

    @Override
    protected DecisionForest parseOutput(Job job) throws IOException {
        Path[] outfiles;
        Configuration conf = job.getConfiguration();
        HashMap<Integer, MapredOutput> output = new HashMap<Integer, MapredOutput>();
        Path outputPath = this.getOutputPath(conf);
        FileSystem fs = outputPath.getFileSystem(conf);
        for (Path path : outfiles = DFUtils.listOutputFiles(fs, outputPath)) {
            for (Pair record : new SequenceFileIterable(path, conf)) {
                output.put(((IntWritable)record.getFirst()).get(), (MapredOutput)record.getSecond());
            }
        }
        return InMemBuilder.processOutput(output);
    }

    private static DecisionForest processOutput(Map<Integer, MapredOutput> output) {
        ArrayList<Node> trees = new ArrayList<Node>();
        for (Map.Entry<Integer, MapredOutput> entry : output.entrySet()) {
            MapredOutput value = entry.getValue();
            trees.add(value.getTree());
        }
        return new DecisionForest(trees);
    }
}

