/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.mlp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.csv.CSVUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.classifier.mlp.MultilayerPerceptron;
import org.apache.mahout.classifier.mlp.TrainMultilayerPerceptron;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RunMultilayerPerceptron {
    private static final Logger log = LoggerFactory.getLogger(RunMultilayerPerceptron.class);

    public static void main(String[] args) throws Exception {
        Parameters parameters = new Parameters();
        if (RunMultilayerPerceptron.parseArgs(args, parameters)) {
            log.info("Load model from {}.", (Object)parameters.modelFilePathStr);
            MultilayerPerceptron mlp = new MultilayerPerceptron(parameters.modelFilePathStr);
            log.info("Topology of MLP: {}.", (Object)Arrays.toString(mlp.getLayerSizeList().toArray()));
            log.info("Read the data...");
            Path inputFilePath = new Path(parameters.inputFilePathStr);
            FileSystem inputFS = inputFilePath.getFileSystem(new Configuration());
            if (!inputFS.exists(inputFilePath)) {
                log.error("Input file '{}' does not exists!", (Object)parameters.inputFilePathStr);
                mlp.close();
                return;
            }
            Path outputFilePath = new Path(parameters.outputFilePathStr);
            FileSystem outputFS = inputFilePath.getFileSystem(new Configuration());
            if (outputFS.exists(outputFilePath)) {
                log.error("Output file '{}' already exists!", (Object)parameters.outputFilePathStr);
                mlp.close();
                return;
            }
            if (!parameters.inputFileFormat.equals("csv")) {
                log.error("Currently only supports for csv format.");
                mlp.close();
                return;
            }
            log.info("Read from column {} to column {}.", (Object)parameters.columnStart, (Object)parameters.columnEnd);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputFS.create(outputFilePath)));
                 BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputFS.open(inputFilePath)));){
                String line;
                if (parameters.skipHeader) {
                    reader.readLine();
                }
                while ((line = reader.readLine()) != null) {
                    String[] tokens = CSVUtils.parseLine((String)line);
                    double[] features = new double[Math.min(parameters.columnEnd, tokens.length) - parameters.columnStart + 1];
                    int i = parameters.columnStart;
                    int j = 0;
                    while (i < Math.min(parameters.columnEnd + 1, tokens.length)) {
                        features[j] = Double.parseDouble(tokens[i]);
                        ++i;
                        ++j;
                    }
                    DenseVector featureVec = new DenseVector(features);
                    Vector res = mlp.getOutput((Vector)featureVec);
                    int mostProbablyLabelIndex = res.maxValueIndex();
                    writer.write(String.valueOf(mostProbablyLabelIndex));
                }
                mlp.close();
                log.info("Labeling finished.");
            }
        }
    }

    private static boolean parseArgs(String[] args, Parameters parameters) throws Exception {
        log.info("Validate and parse arguments...");
        DefaultOptionBuilder optionBuilder = new DefaultOptionBuilder();
        GroupBuilder groupBuilder = new GroupBuilder();
        ArgumentBuilder argumentBuilder = new ArgumentBuilder();
        DefaultOption inputFileFormatOption = optionBuilder.withLongName("format").withShortName("f").withArgument(argumentBuilder.withName("file type").withDefault((Object)"csv").withMinimum(1).withMaximum(1).create()).withDescription("type of input file, currently support 'csv'").create();
        ArrayList<Integer> columnRangeDefault = new ArrayList<Integer>();
        columnRangeDefault.add(0);
        columnRangeDefault.add(Integer.MAX_VALUE);
        DefaultOption skipHeaderOption = optionBuilder.withLongName("skipHeader").withShortName("sh").withRequired(false).withDescription("whether to skip the first row of the input file").create();
        DefaultOption inputColumnRangeOption = optionBuilder.withLongName("columnRange").withShortName("cr").withDescription("the column range of the input file, start from 0").withArgument(argumentBuilder.withName("range").withMinimum(2).withMaximum(2).withDefaults(columnRangeDefault).create()).create();
        Group inputFileTypeGroup = groupBuilder.withOption((Option)skipHeaderOption).withOption((Option)inputColumnRangeOption).withOption((Option)inputFileFormatOption).create();
        DefaultOption inputOption = optionBuilder.withLongName("input").withShortName("i").withRequired(true).withArgument(argumentBuilder.withName("file path").withMinimum(1).withMaximum(1).create()).withDescription("the file path of unlabelled dataset").withChildren(inputFileTypeGroup).create();
        DefaultOption modelOption = optionBuilder.withLongName("model").withShortName("mo").withRequired(true).withArgument(argumentBuilder.withName("model file").withMinimum(1).withMaximum(1).create()).withDescription("the file path of the model").create();
        DefaultOption labelsOption = optionBuilder.withLongName("labels").withShortName("labels").withArgument(argumentBuilder.withName("label-name").withMinimum(2).create()).withDescription("an ordered list of label names").create();
        Group labelsGroup = groupBuilder.withOption((Option)labelsOption).create();
        DefaultOption outputOption = optionBuilder.withLongName("output").withShortName("o").withRequired(true).withArgument(argumentBuilder.withConsumeRemaining("file path").withMinimum(1).withMaximum(1).create()).withDescription("the file path of labelled results").withChildren(labelsGroup).create();
        Parser parser = new Parser();
        Group normalOption = groupBuilder.withOption((Option)inputOption).withOption((Option)modelOption).withOption((Option)outputOption).create();
        parser.setGroup(normalOption);
        CommandLine commandLine = parser.parseAndHelp(args);
        if (commandLine == null) {
            return false;
        }
        parameters.inputFilePathStr = TrainMultilayerPerceptron.getString(commandLine, (Option)inputOption);
        parameters.inputFileFormat = TrainMultilayerPerceptron.getString(commandLine, (Option)inputFileFormatOption);
        parameters.skipHeader = commandLine.hasOption((Option)skipHeaderOption);
        parameters.modelFilePathStr = TrainMultilayerPerceptron.getString(commandLine, (Option)modelOption);
        parameters.outputFilePathStr = TrainMultilayerPerceptron.getString(commandLine, (Option)outputOption);
        List columnRange = commandLine.getValues((Option)inputColumnRangeOption);
        parameters.columnStart = Integer.parseInt(columnRange.get(0).toString());
        parameters.columnEnd = Integer.parseInt(columnRange.get(1).toString());
        return true;
    }

    static class Parameters {
        String inputFilePathStr;
        String inputFileFormat;
        String modelFilePathStr;
        String outputFilePathStr;
        int columnStart;
        int columnEnd;
        boolean skipHeader;

        Parameters() {
        }
    }
}

