/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sequencelearning.hmm;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmModel;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SparseMatrix;
import org.apache.mahout.math.Vector;

public final class HmmUtils {
    private HmmUtils() {
    }

    public static Matrix getCumulativeTransitionMatrix(HmmModel model) {
        int hiddenStates = model.getNrOfHiddenStates();
        Matrix transitionMatrix = model.getTransitionMatrix();
        DenseMatrix resultMatrix = new DenseMatrix(hiddenStates, hiddenStates);
        for (int i = 0; i < hiddenStates; ++i) {
            double sum = 0.0;
            for (int j = 0; j < hiddenStates; ++j) {
                resultMatrix.set(i, j, sum += transitionMatrix.get(i, j));
            }
            resultMatrix.set(i, hiddenStates - 1, 1.0);
        }
        return resultMatrix;
    }

    public static Matrix getCumulativeOutputMatrix(HmmModel model) {
        int hiddenStates = model.getNrOfHiddenStates();
        int outputStates = model.getNrOfOutputStates();
        Matrix outputMatrix = model.getEmissionMatrix();
        DenseMatrix resultMatrix = new DenseMatrix(hiddenStates, outputStates);
        for (int i = 0; i < hiddenStates; ++i) {
            double sum = 0.0;
            for (int j = 0; j < outputStates; ++j) {
                resultMatrix.set(i, j, sum += outputMatrix.get(i, j));
            }
            resultMatrix.set(i, outputStates - 1, 1.0);
        }
        return resultMatrix;
    }

    public static Vector getCumulativeInitialProbabilities(HmmModel model) {
        int hiddenStates = model.getNrOfHiddenStates();
        Vector initialProbabilities = model.getInitialProbabilities();
        DenseVector resultVector = new DenseVector(initialProbabilities.size());
        double sum = 0.0;
        for (int i = 0; i < hiddenStates; ++i) {
            resultVector.set(i, sum += initialProbabilities.get(i));
        }
        resultVector.set(hiddenStates - 1, 1.0);
        return resultVector;
    }

    public static void validate(HmmModel model) {
        int j;
        int i;
        if (model == null) {
            return;
        }
        Preconditions.checkArgument((model.getNrOfHiddenStates() > 0 ? 1 : 0) != 0, (Object)"Error: The number of hidden states has to be greater than 0");
        Preconditions.checkArgument((model.getNrOfOutputStates() > 0 ? 1 : 0) != 0, (Object)"Error: The number of output states has to be greater than 0!");
        Preconditions.checkArgument((model.getInitialProbabilities() != null && model.getInitialProbabilities().size() == model.getNrOfHiddenStates() ? 1 : 0) != 0, (Object)"Error: The vector of initial probabilities is not initialized!");
        double sum = 0.0;
        for (i = 0; i < model.getInitialProbabilities().size(); ++i) {
            Preconditions.checkArgument((model.getInitialProbabilities().get(i) >= 0.0 ? 1 : 0) != 0, (String)"Error: Initial probability of state %d is negative", (Object[])new Object[]{i});
            sum += model.getInitialProbabilities().get(i);
        }
        Preconditions.checkArgument((Math.abs(sum - 1.0) <= 1.0E-5 ? 1 : 0) != 0, (Object)"Error: Initial probabilities do not add up to 1");
        Preconditions.checkNotNull((Object)model.getEmissionMatrix(), (Object)"Error: The output state matrix is not initialized!");
        Preconditions.checkArgument((model.getEmissionMatrix().numRows() == model.getNrOfHiddenStates() && model.getEmissionMatrix().numCols() == model.getNrOfOutputStates() ? 1 : 0) != 0, (Object)"Error: The output state matrix is not of the form nrOfHiddenStates x nrOfOutputStates");
        for (i = 0; i < model.getEmissionMatrix().numRows(); ++i) {
            sum = 0.0;
            for (j = 0; j < model.getEmissionMatrix().numCols(); ++j) {
                Preconditions.checkArgument((model.getEmissionMatrix().get(i, j) >= 0.0 ? 1 : 0) != 0, (Object)("The output state probability from hidden state " + i + " to output state " + j + " is negative"));
                sum += model.getEmissionMatrix().get(i, j);
            }
            Preconditions.checkArgument((Math.abs(sum - 1.0) <= 1.0E-5 ? 1 : 0) != 0, (String)"Error: The output state probabilities for hidden state %d don't add up to 1", (Object[])new Object[]{i});
        }
        Preconditions.checkArgument((model.getTransitionMatrix() != null ? 1 : 0) != 0, (Object)"Error: The hidden state matrix is not initialized!");
        Preconditions.checkArgument((model.getTransitionMatrix().numRows() == model.getNrOfHiddenStates() && model.getTransitionMatrix().numCols() == model.getNrOfHiddenStates() ? 1 : 0) != 0, (Object)"Error: The output state matrix is not of the form nrOfHiddenStates x nrOfHiddenStates");
        for (i = 0; i < model.getTransitionMatrix().numRows(); ++i) {
            sum = 0.0;
            for (j = 0; j < model.getTransitionMatrix().numCols(); ++j) {
                Preconditions.checkArgument((model.getTransitionMatrix().get(i, j) >= 0.0 ? 1 : 0) != 0, (String)"Error: The transition probability from hidden state %d to hidden state %d is negative", (Object[])new Object[]{i, j});
                sum += model.getTransitionMatrix().get(i, j);
            }
            Preconditions.checkArgument((Math.abs(sum - 1.0) <= 1.0E-5 ? 1 : 0) != 0, (Object)("Error: The transition probabilities for hidden state " + i + " don't add up to 1."));
        }
    }

    public static int[] encodeStateSequence(HmmModel model, Collection<String> sequence, boolean observed, int defaultValue) {
        int[] encoded = new int[sequence.size()];
        Iterator<String> seqIter = sequence.iterator();
        for (int i = 0; i < sequence.size(); ++i) {
            String nextState = seqIter.next();
            int nextID = observed ? model.getOutputStateID(nextState) : model.getHiddenStateID(nextState);
            encoded[i] = nextID < 0 ? defaultValue : nextID;
        }
        return encoded;
    }

    public static List<String> decodeStateSequence(HmmModel model, int[] sequence, boolean observed, String defaultValue) {
        ArrayList<String> decoded = new ArrayList<String>(sequence.length);
        for (int position : sequence) {
            String nextState = observed ? model.getOutputStateName(position) : model.getHiddenStateName(position);
            decoded.add(nextState == null ? defaultValue : nextState);
        }
        return decoded;
    }

    public static void normalizeModel(HmmModel model) {
        int i;
        Vector ip = model.getInitialProbabilities();
        Matrix emission = model.getEmissionMatrix();
        Matrix transition = model.getTransitionMatrix();
        double isum = 0.0;
        for (i = 0; i < model.getNrOfHiddenStates(); ++i) {
            int j;
            isum += ip.getQuick(i);
            double sum = 0.0;
            for (j = 0; j < model.getNrOfHiddenStates(); ++j) {
                sum += transition.getQuick(i, j);
            }
            if (sum != 1.0) {
                for (j = 0; j < model.getNrOfHiddenStates(); ++j) {
                    transition.setQuick(i, j, transition.getQuick(i, j) / sum);
                }
            }
            sum = 0.0;
            for (j = 0; j < model.getNrOfOutputStates(); ++j) {
                sum += emission.getQuick(i, j);
            }
            if (sum == 1.0) continue;
            for (j = 0; j < model.getNrOfOutputStates(); ++j) {
                emission.setQuick(i, j, emission.getQuick(i, j) / sum);
            }
        }
        if (isum != 1.0) {
            for (i = 0; i < model.getNrOfHiddenStates(); ++i) {
                ip.setQuick(i, ip.getQuick(i) / isum);
            }
        }
    }

    public static HmmModel truncateModel(HmmModel model, double threshold) {
        Vector ip = model.getInitialProbabilities();
        Matrix em = model.getEmissionMatrix();
        Matrix tr = model.getTransitionMatrix();
        RandomAccessSparseVector sparseIp = new RandomAccessSparseVector(model.getNrOfHiddenStates());
        SparseMatrix sparseEm = new SparseMatrix(model.getNrOfHiddenStates(), model.getNrOfOutputStates());
        SparseMatrix sparseTr = new SparseMatrix(model.getNrOfHiddenStates(), model.getNrOfHiddenStates());
        for (int i = 0; i < model.getNrOfHiddenStates(); ++i) {
            int j;
            double value = ip.getQuick(i);
            if (value > threshold) {
                sparseIp.setQuick(i, value);
            }
            for (j = 0; j < model.getNrOfHiddenStates(); ++j) {
                value = tr.getQuick(i, j);
                if (!(value > threshold)) continue;
                sparseTr.setQuick(i, j, value);
            }
            for (j = 0; j < model.getNrOfOutputStates(); ++j) {
                value = em.getQuick(i, j);
                if (!(value > threshold)) continue;
                sparseEm.setQuick(i, j, value);
            }
        }
        HmmModel sparseModel = new HmmModel((Matrix)sparseTr, (Matrix)sparseEm, (Vector)sparseIp);
        HmmUtils.normalizeModel(sparseModel);
        sparseModel.registerHiddenStateNames(model.getHiddenStateNames());
        sparseModel.registerOutputStateNames(model.getOutputStateNames());
        return sparseModel;
    }
}

