/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sequencelearning.hmm;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Scanner;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.io.Charsets;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmEvaluator;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmModel;
import org.apache.mahout.classifier.sequencelearning.hmm.LossyHmmSerializer;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;

public final class ViterbiEvaluator {
    private ViterbiEvaluator() {
    }

    public static void main(String[] args) throws IOException {
        DefaultOptionBuilder optionBuilder = new DefaultOptionBuilder();
        ArgumentBuilder argumentBuilder = new ArgumentBuilder();
        DefaultOption inputOption = DefaultOptionCreator.inputOption().create();
        DefaultOption outputOption = DefaultOptionCreator.outputOption().create();
        DefaultOption modelOption = optionBuilder.withLongName("model").withDescription("Path to serialized HMM model").withShortName("m").withArgument(argumentBuilder.withMaximum(1).withMinimum(1).withName("path").create()).withRequired(true).create();
        DefaultOption likelihoodOption = optionBuilder.withLongName("likelihood").withDescription("Compute likelihood of observed sequence").withShortName("l").withRequired(false).create();
        Group optionGroup = new GroupBuilder().withOption((Option)inputOption).withOption((Option)outputOption).withOption((Option)modelOption).withOption((Option)likelihoodOption).withName("Options").create();
        try {
            HmmModel model;
            Parser parser = new Parser();
            parser.setGroup(optionGroup);
            CommandLine commandLine = parser.parse(args);
            String input = (String)commandLine.getValue((Option)inputOption);
            String output = (String)commandLine.getValue((Option)outputOption);
            String modelPath = (String)commandLine.getValue((Option)modelOption);
            boolean computeLikelihood = commandLine.hasOption((Option)likelihoodOption);
            try (DataInputStream modelStream = new DataInputStream(new FileInputStream(modelPath));){
                model = LossyHmmSerializer.deserialize(modelStream);
            }
            ArrayList<Integer> observations = new ArrayList<Integer>();
            try (Scanner scanner = new Scanner((InputStream)new FileInputStream(input), "UTF-8");){
                while (scanner.hasNextInt()) {
                    observations.add(scanner.nextInt());
                }
            }
            int[] observationsArray = new int[observations.size()];
            for (int i = 0; i < observations.size(); ++i) {
                observationsArray[i] = (Integer)observations.get(i);
            }
            int[] hiddenStates = HmmEvaluator.decode(model, observationsArray, true);
            try (PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(output), Charsets.UTF_8), true);){
                for (int hiddenState : hiddenStates) {
                    writer.print(hiddenState);
                    writer.print(' ');
                }
            }
            if (computeLikelihood) {
                System.out.println("Likelihood: " + HmmEvaluator.modelLikelihood(model, observationsArray, true));
            }
        }
        catch (OptionException e) {
            CommandLineUtil.printHelp(optionGroup);
        }
    }
}

