/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.mahout.common.RandomUtils;

public final class IntPairWritable
extends BinaryComparable
implements WritableComparable<BinaryComparable>,
Cloneable {
    static final int INT_BYTE_LENGTH = 4;
    static final int INT_PAIR_BYTE_LENGTH = 8;
    private byte[] b = new byte[8];

    public IntPairWritable() {
        this.setFirst(0);
        this.setSecond(0);
    }

    public IntPairWritable(IntPairWritable pair) {
        this.b = Arrays.copyOf(pair.getBytes(), 8);
    }

    public IntPairWritable(int x, int y) {
        IntPairWritable.putInt(x, this.b, 0);
        IntPairWritable.putInt(y, this.b, 4);
    }

    public void set(int x, int y) {
        IntPairWritable.putInt(x, this.b, 0);
        IntPairWritable.putInt(y, this.b, 4);
    }

    public void setFirst(int x) {
        IntPairWritable.putInt(x, this.b, 0);
    }

    public int getFirst() {
        return IntPairWritable.getInt(this.b, 0);
    }

    public void setSecond(int y) {
        IntPairWritable.putInt(y, this.b, 4);
    }

    public int getSecond() {
        return IntPairWritable.getInt(this.b, 4);
    }

    public void readFields(DataInput in) throws IOException {
        in.readFully(this.b);
    }

    public void write(DataOutput out) throws IOException {
        out.write(this.b);
    }

    public int hashCode() {
        return Arrays.hashCode(this.b);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof IntPairWritable)) {
            return false;
        }
        IntPairWritable other = (IntPairWritable)obj;
        return Arrays.equals(this.b, other.b);
    }

    public int compareTo(BinaryComparable other) {
        return Comparator.doCompare(this.b, 0, ((IntPairWritable)other).b, 0);
    }

    public Object clone() {
        return new IntPairWritable(this);
    }

    public String toString() {
        return "(" + this.getFirst() + ", " + this.getSecond() + ')';
    }

    public byte[] getBytes() {
        return this.b;
    }

    public int getLength() {
        return 8;
    }

    private static void putInt(int value, byte[] b, int offset) {
        int i = offset;
        for (int j = 24; j >= 0; j -= 8) {
            b[i] = (byte)(value >> j);
            ++i;
        }
    }

    private static int getInt(byte[] b, int offset) {
        int value = 0;
        int i = offset;
        for (int j = 24; j >= 0; j -= 8) {
            value |= (b[i] & 0xFF) << j;
            ++i;
        }
        return value;
    }

    static {
        WritableComparator.define(IntPairWritable.class, (WritableComparator)new Comparator());
    }

    public static class Frequency
    implements Comparable<Frequency>,
    Serializable {
        private final IntPairWritable pair;
        private final double frequency;

        public Frequency(IntPairWritable bigram, double frequency) {
            this.pair = new IntPairWritable(bigram);
            this.frequency = frequency;
        }

        public double getFrequency() {
            return this.frequency;
        }

        public IntPairWritable getPair() {
            return this.pair;
        }

        public int hashCode() {
            return this.pair.hashCode() + RandomUtils.hashDouble((double)this.frequency);
        }

        public boolean equals(Object right) {
            if (!(right instanceof Frequency)) {
                return false;
            }
            Frequency that = (Frequency)right;
            return this.pair.equals(that.pair) && this.frequency == that.frequency;
        }

        @Override
        public int compareTo(Frequency that) {
            if (this.frequency < that.frequency) {
                return -1;
            }
            if (this.frequency > that.frequency) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return this.pair + "\t" + this.frequency;
        }
    }

    public static class FirstGroupingComparator
    extends WritableComparator
    implements Serializable {
        public FirstGroupingComparator() {
            super(IntPairWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int firstb2;
            int firstb1 = WritableComparator.readInt((byte[])b1, (int)s1);
            if (firstb1 < (firstb2 = WritableComparator.readInt((byte[])b2, (int)s2))) {
                return -1;
            }
            if (firstb1 > firstb2) {
                return 1;
            }
            return 0;
        }

        public int compare(Object o1, Object o2) {
            int firstb2;
            int firstb1 = ((IntPairWritable)o1).getFirst();
            if (firstb1 < (firstb2 = ((IntPairWritable)o2).getFirst())) {
                return -1;
            }
            if (firstb1 > firstb2) {
                return 1;
            }
            return 0;
        }
    }

    public static final class Comparator
    extends WritableComparator
    implements Serializable {
        public Comparator() {
            super(IntPairWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return Comparator.doCompare(b1, s1, b2, s2);
        }

        static int doCompare(byte[] b1, int s1, byte[] b2, int s2) {
            int compare1 = Comparator.compareInts(b1, s1, b2, s2);
            if (compare1 != 0) {
                return compare1;
            }
            return Comparator.compareInts(b1, s1 + 4, b2, s2 + 4);
        }

        private static int compareInts(byte[] b1, int s1, byte[] b2, int s2) {
            int end1 = s1 + 4;
            int i = s1;
            int j = s2;
            while (i < end1) {
                int a = b1[i];
                int b = b2[j];
                if (i > s1) {
                    a &= 0xFF;
                    b &= 0xFF;
                }
                if (a != b) {
                    return a - b;
                }
                ++i;
                ++j;
            }
            return 0;
        }
    }
}

