/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterator;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.Functions;

public final class TimesSquaredJob {
    public static final String INPUT_VECTOR = "DistributedMatrix.times.inputVector";
    public static final String IS_SPARSE_OUTPUT = "DistributedMatrix.times.outputVector.sparse";
    public static final String OUTPUT_VECTOR_DIMENSION = "DistributedMatrix.times.output.dimension";
    public static final String OUTPUT_VECTOR_FILENAME = "DistributedMatrix.times.outputVector";

    private TimesSquaredJob() {
    }

    public static Job createTimesSquaredJob(Vector v, Path matrixInputPath, Path outputVectorPath) throws IOException {
        return TimesSquaredJob.createTimesSquaredJob(new Configuration(), v, matrixInputPath, outputVectorPath);
    }

    public static Job createTimesSquaredJob(Configuration initialConf, Vector v, Path matrixInputPath, Path outputVectorPath) throws IOException {
        return TimesSquaredJob.createTimesSquaredJob(initialConf, v, matrixInputPath, outputVectorPath, TimesSquaredMapper.class, VectorSummingReducer.class);
    }

    public static Job createTimesJob(Vector v, int outDim, Path matrixInputPath, Path outputVectorPath) throws IOException {
        return TimesSquaredJob.createTimesJob(new Configuration(), v, outDim, matrixInputPath, outputVectorPath);
    }

    public static Job createTimesJob(Configuration initialConf, Vector v, int outDim, Path matrixInputPath, Path outputVectorPath) throws IOException {
        return TimesSquaredJob.createTimesSquaredJob(initialConf, v, outDim, matrixInputPath, outputVectorPath, TimesMapper.class, VectorSummingReducer.class);
    }

    public static Job createTimesSquaredJob(Vector v, Path matrixInputPath, Path outputVectorPathBase, Class<? extends TimesSquaredMapper> mapClass, Class<? extends VectorSummingReducer> redClass) throws IOException {
        return TimesSquaredJob.createTimesSquaredJob(new Configuration(), v, matrixInputPath, outputVectorPathBase, mapClass, redClass);
    }

    public static Job createTimesSquaredJob(Configuration initialConf, Vector v, Path matrixInputPath, Path outputVectorPathBase, Class<? extends TimesSquaredMapper> mapClass, Class<? extends VectorSummingReducer> redClass) throws IOException {
        return TimesSquaredJob.createTimesSquaredJob(initialConf, v, v.size(), matrixInputPath, outputVectorPathBase, mapClass, redClass);
    }

    public static Job createTimesSquaredJob(Vector v, int outputVectorDim, Path matrixInputPath, Path outputVectorPathBase, Class<? extends TimesSquaredMapper> mapClass, Class<? extends VectorSummingReducer> redClass) throws IOException {
        return TimesSquaredJob.createTimesSquaredJob(new Configuration(), v, outputVectorDim, matrixInputPath, outputVectorPathBase, mapClass, redClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Job createTimesSquaredJob(Configuration initialConf, Vector v, int outputVectorDim, Path matrixInputPath, Path outputVectorPathBase, Class<? extends TimesSquaredMapper> mapClass, Class<? extends VectorSummingReducer> redClass) throws IOException {
        FileSystem fs = FileSystem.get((URI)matrixInputPath.toUri(), (Configuration)initialConf);
        matrixInputPath = fs.makeQualified(matrixInputPath);
        outputVectorPathBase = fs.makeQualified(outputVectorPathBase);
        long now = System.nanoTime();
        Path inputVectorPath = new Path(outputVectorPathBase, "DistributedMatrix.times.inputVector/" + now);
        SequenceFile.Writer inputVectorPathWriter = null;
        try {
            inputVectorPathWriter = new SequenceFile.Writer(fs, initialConf, inputVectorPath, NullWritable.class, VectorWritable.class);
            inputVectorPathWriter.append((Writable)NullWritable.get(), (Writable)new VectorWritable(v));
        }
        catch (Throwable throwable) {
            Closeables.close(inputVectorPathWriter, (boolean)false);
            throw throwable;
        }
        Closeables.close((Closeable)inputVectorPathWriter, (boolean)false);
        URI ivpURI = inputVectorPath.toUri();
        DistributedCache.setCacheFiles((URI[])new URI[]{ivpURI}, (Configuration)initialConf);
        Job job = HadoopUtil.prepareJob(matrixInputPath, new Path(outputVectorPathBase, OUTPUT_VECTOR_FILENAME), SequenceFileInputFormat.class, mapClass, NullWritable.class, VectorWritable.class, redClass, NullWritable.class, VectorWritable.class, SequenceFileOutputFormat.class, initialConf);
        job.setCombinerClass(redClass);
        job.setJobName("TimesSquaredJob: " + matrixInputPath);
        Configuration conf = job.getConfiguration();
        conf.set(INPUT_VECTOR, ivpURI.toString());
        conf.setBoolean(IS_SPARSE_OUTPUT, !v.isDense());
        conf.setInt(OUTPUT_VECTOR_DIMENSION, outputVectorDim);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector retrieveTimesSquaredOutputVector(Path outputVectorTmpPath, Configuration conf) throws IOException {
        Path outputFile = new Path(outputVectorTmpPath, "DistributedMatrix.times.outputVector/part-r-00000");
        SequenceFileValueIterator iterator = new SequenceFileValueIterator(outputFile, true, conf);
        try {
            Vector vector = ((VectorWritable)iterator.next()).get();
            return vector;
        }
        finally {
            Closeables.close(iterator, (boolean)true);
        }
    }

    public static class VectorSummingReducer
    extends Reducer<NullWritable, VectorWritable, NullWritable, VectorWritable> {
        private Vector outputVector;

        protected void setup(Reducer.Context ctx) throws IOException, InterruptedException {
            Configuration conf = ctx.getConfiguration();
            int outputDimension = conf.getInt(TimesSquaredJob.OUTPUT_VECTOR_DIMENSION, Integer.MAX_VALUE);
            this.outputVector = conf.getBoolean(TimesSquaredJob.IS_SPARSE_OUTPUT, false) ? new RandomAccessSparseVector(outputDimension, 10) : new DenseVector(outputDimension);
        }

        protected void reduce(NullWritable key, Iterable<VectorWritable> vectors, Reducer.Context ctx) throws IOException, InterruptedException {
            for (VectorWritable v : vectors) {
                if (v == null) continue;
                this.outputVector.assign(v.get(), Functions.PLUS);
            }
            ctx.write((Object)NullWritable.get(), (Object)new VectorWritable(this.outputVector));
        }
    }

    public static class TimesMapper
    extends TimesSquaredMapper<IntWritable> {
        @Override
        protected void map(IntWritable rowNum, VectorWritable v, Mapper.Context context) throws IOException, InterruptedException {
            double d = this.scale(v);
            if (d != 0.0) {
                this.getOutputVector().setQuick(rowNum.get(), d);
            }
        }
    }

    public static class TimesSquaredMapper<T extends WritableComparable>
    extends Mapper<T, VectorWritable, NullWritable, VectorWritable> {
        private Vector outputVector;
        private Vector inputVector;

        Vector getOutputVector() {
            return this.outputVector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setup(Mapper.Context ctx) throws IOException, InterruptedException {
            try {
                Configuration conf = ctx.getConfiguration();
                Path[] localFiles = DistributedCache.getLocalCacheFiles((Configuration)conf);
                Preconditions.checkArgument((localFiles != null && localFiles.length >= 1 ? 1 : 0) != 0, (Object)"missing paths from the DistributedCache");
                Path inputVectorPath = HadoopUtil.getSingleCachedFile(conf);
                SequenceFileValueIterator iterator = new SequenceFileValueIterator(inputVectorPath, true, conf);
                try {
                    this.inputVector = ((VectorWritable)iterator.next()).get();
                }
                finally {
                    Closeables.close(iterator, (boolean)true);
                }
                int outDim = conf.getInt(TimesSquaredJob.OUTPUT_VECTOR_DIMENSION, Integer.MAX_VALUE);
                this.outputVector = conf.getBoolean(TimesSquaredJob.IS_SPARSE_OUTPUT, false) ? new RandomAccessSparseVector(outDim, 10) : new DenseVector(outDim);
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
        }

        protected void map(T key, VectorWritable v, Mapper.Context context) throws IOException, InterruptedException {
            double d = this.scale(v);
            if (d == 1.0) {
                this.outputVector.assign(v.get(), Functions.PLUS);
            } else if (d != 0.0) {
                this.outputVector.assign(v.get(), Functions.plusMult((double)d));
            }
        }

        protected double scale(VectorWritable v) {
            return v.get().dot(this.inputVector);
        }

        protected void cleanup(Mapper.Context ctx) throws IOException, InterruptedException {
            ctx.write((Object)NullWritable.get(), (Object)new VectorWritable(this.outputVector));
        }
    }
}

