/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.similarity.cooccurrence.measures;

import org.apache.mahout.math.Vector;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.VectorSimilarityMeasure;

public class EuclideanDistanceSimilarity
implements VectorSimilarityMeasure {
    @Override
    public Vector normalize(Vector vector) {
        return vector;
    }

    @Override
    public double norm(Vector vector) {
        double norm = 0.0;
        for (Vector.Element e : vector.nonZeroes()) {
            double value = e.get();
            norm += value * value;
        }
        return norm;
    }

    @Override
    public double aggregate(double valueA, double nonZeroValueB) {
        return valueA * nonZeroValueB;
    }

    @Override
    public double similarity(double dots, double normA, double normB, int numberOfColumns) {
        double euclideanDistance = Math.sqrt(Math.max(0.0, normA - 2.0 * dots + normB));
        return 1.0 / (1.0 + euclideanDistance);
    }

    @Override
    public boolean consider(int numNonZeroEntriesA, int numNonZeroEntriesB, double maxValueA, double maxValueB, double threshold) {
        return true;
    }
}

