/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.similarity.cooccurrence.measures;

import java.util.Arrays;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.CityBlockSimilarity;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.CooccurrenceCountSimilarity;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.CosineSimilarity;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.EuclideanDistanceSimilarity;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.LoglikelihoodSimilarity;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.PearsonCorrelationSimilarity;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.TanimotoCoefficientSimilarity;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.VectorSimilarityMeasure;

public enum VectorSimilarityMeasures {
    SIMILARITY_COOCCURRENCE(CooccurrenceCountSimilarity.class),
    SIMILARITY_LOGLIKELIHOOD(LoglikelihoodSimilarity.class),
    SIMILARITY_TANIMOTO_COEFFICIENT(TanimotoCoefficientSimilarity.class),
    SIMILARITY_CITY_BLOCK(CityBlockSimilarity.class),
    SIMILARITY_COSINE(CosineSimilarity.class),
    SIMILARITY_PEARSON_CORRELATION(PearsonCorrelationSimilarity.class),
    SIMILARITY_EUCLIDEAN_DISTANCE(EuclideanDistanceSimilarity.class);

    private final Class<? extends VectorSimilarityMeasure> implementingClass;

    private VectorSimilarityMeasures(Class<? extends VectorSimilarityMeasure> impl) {
        this.implementingClass = impl;
    }

    public String getClassname() {
        return this.implementingClass.getName();
    }

    public static String list() {
        return Arrays.toString((Object[])VectorSimilarityMeasures.values());
    }
}

