/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.io.IOException;
import org.apache.commons.lang3.Validate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.UpperTriangular;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.Omega;

public final class YtYJob {
    public static final String PROP_OMEGA_SEED = "ssvd.omegaseed";
    public static final String PROP_K = "ssvd.k";
    public static final String PROP_P = "ssvd.p";
    public static final String OUTPUT_YT_Y = "part-";

    private YtYJob() {
    }

    public static void run(Configuration conf, Path[] inputPaths, Path outputPath, int k, int p, long seed) throws ClassNotFoundException, InterruptedException, IOException {
        Job job = new Job(conf);
        job.setJobName("YtY-job");
        job.setJarByClass(YtYJob.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])inputPaths);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        SequenceFileOutputFormat.setOutputCompressionType((Job)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(VectorWritable.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(VectorWritable.class);
        job.setMapperClass(YtYMapper.class);
        job.getConfiguration().setLong(PROP_OMEGA_SEED, seed);
        job.getConfiguration().setInt(PROP_K, k);
        job.getConfiguration().setInt(PROP_P, p);
        job.setNumReduceTasks(1);
        job.submit();
        job.waitForCompletion(false);
        if (!job.isSuccessful()) {
            throw new IOException("YtY job unsuccessful.");
        }
    }

    public static class YtYReducer
    extends Reducer<IntWritable, VectorWritable, IntWritable, VectorWritable> {
        private final VectorWritable accum = new VectorWritable();
        private DenseVector acc;

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            int k = context.getConfiguration().getInt(YtYJob.PROP_K, -1);
            int p = context.getConfiguration().getInt(YtYJob.PROP_P, -1);
            Validate.isTrue((k > 0 ? 1 : 0) != 0, (String)"invalid k parameter", (Object[])new Object[0]);
            Validate.isTrue((p > 0 ? 1 : 0) != 0, (String)"invalid p parameter", (Object[])new Object[0]);
            this.acc = new DenseVector(k + p);
            this.accum.set((Vector)this.acc);
        }

        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            context.write((Object)new IntWritable(), (Object)this.accum);
        }

        protected void reduce(IntWritable key, Iterable<VectorWritable> values, Reducer.Context arg2) throws IOException, InterruptedException {
            for (VectorWritable vw : values) {
                this.acc.addAll(vw.get());
            }
        }
    }

    public static class YtYMapper
    extends Mapper<Writable, VectorWritable, IntWritable, VectorWritable> {
        private int kp;
        private Omega omega;
        private UpperTriangular mYtY;
        private Vector yRow;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            int k = context.getConfiguration().getInt(YtYJob.PROP_K, -1);
            int p = context.getConfiguration().getInt(YtYJob.PROP_P, -1);
            Validate.isTrue((k > 0 ? 1 : 0) != 0, (String)"invalid k parameter", (Object[])new Object[0]);
            Validate.isTrue((p > 0 ? 1 : 0) != 0, (String)"invalid p parameter", (Object[])new Object[0]);
            this.kp = k + p;
            long omegaSeed = Long.parseLong(context.getConfiguration().get(YtYJob.PROP_OMEGA_SEED));
            this.omega = new Omega(omegaSeed, k + p);
            this.mYtY = new UpperTriangular(this.kp);
            this.yRow = new DenseVector(this.kp);
        }

        protected void map(Writable key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
            this.omega.computeYRow(value.get(), this.yRow);
            if (this.yRow.isDense()) {
                for (int i = 0; i < this.kp; ++i) {
                    double yi = this.yRow.getQuick(i);
                    if (yi == 0.0) continue;
                    for (int j = i; j < this.kp; ++j) {
                        double yj = this.yRow.getQuick(j);
                        if (yj == 0.0) continue;
                        this.mYtY.setQuick(i, j, this.mYtY.getQuick(i, j) + yi * yj);
                    }
                }
            } else {
                for (Vector.Element eli : this.yRow.nonZeroes()) {
                    int i = eli.index();
                    for (Vector.Element elj : this.yRow.nonZeroes()) {
                        int j = elj.index();
                        if (j < i) continue;
                        this.mYtY.setQuick(i, j, this.mYtY.getQuick(i, j) + eli.get() * elj.get());
                    }
                }
            }
        }

        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)new IntWritable(context.getTaskAttemptID().getTaskID().getId()), (Object)new VectorWritable((Vector)new DenseVector(this.mYtY.getData())));
        }
    }
}

