/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.stats;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixWritable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.stats.OnlineAuc;

public class GlobalOnlineAuc
implements OnlineAuc {
    public static final int HISTORY = 10;
    private int windowSize = Integer.MAX_VALUE;
    private ReplacementPolicy policy = ReplacementPolicy.FIFO;
    private final Random random = RandomUtils.getRandom();
    private Matrix scores;
    private Vector averages;
    private Vector samples;

    public GlobalOnlineAuc() {
        int numCategories = 2;
        this.scores = new DenseMatrix(numCategories, 10);
        this.scores.assign(Double.NaN);
        this.averages = new DenseVector(numCategories);
        this.averages.assign(0.5);
        this.samples = new DenseVector(numCategories);
    }

    @Override
    public double addSample(int category, String groupKey, double score) {
        return this.addSample(category, score);
    }

    @Override
    public double addSample(int category, double score) {
        int n = (int)this.samples.get(category);
        if (n < 10) {
            this.scores.set(category, n, score);
        } else {
            switch (this.policy) {
                case FIFO: {
                    this.scores.set(category, n % 10, score);
                    break;
                }
                case FAIR: {
                    int j1 = this.random.nextInt(n + 1);
                    if (j1 >= 10) break;
                    this.scores.set(category, j1, score);
                    break;
                }
                case RANDOM: {
                    int j2 = this.random.nextInt(10);
                    this.scores.set(category, j2, score);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown policy: " + (Object)((Object)this.policy));
                }
            }
        }
        this.samples.set(category, (double)(n + 1));
        if (this.samples.minValue() >= 1.0) {
            Vector row = this.scores.viewRow(1 - category);
            double m = 0.0;
            double count = 0.0;
            for (Vector.Element element : row.all()) {
                double v = element.get();
                if (Double.isNaN(v)) continue;
                count += 1.0;
                if (score > v) {
                    m += 1.0;
                    continue;
                }
                if (score != v) continue;
                m += 0.5;
            }
            this.averages.set(category, this.averages.get(category) + (m / count - this.averages.get(category)) / Math.min((double)this.windowSize, this.samples.get(category)));
        }
        return this.auc();
    }

    @Override
    public double auc() {
        return (1.0 - this.averages.get(0) + this.averages.get(1)) / 2.0;
    }

    public double value() {
        return this.auc();
    }

    @Override
    public void setPolicy(ReplacementPolicy policy) {
        this.policy = policy;
    }

    @Override
    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.windowSize);
        out.writeInt(this.policy.ordinal());
        MatrixWritable.writeMatrix((DataOutput)out, (Matrix)this.scores);
        VectorWritable.writeVector((DataOutput)out, (Vector)this.averages);
        VectorWritable.writeVector((DataOutput)out, (Vector)this.samples);
    }

    public void readFields(DataInput in) throws IOException {
        this.windowSize = in.readInt();
        this.policy = ReplacementPolicy.values()[in.readInt()];
        this.scores = MatrixWritable.readMatrix((DataInput)in);
        this.averages = VectorWritable.readVector((DataInput)in);
        this.samples = VectorWritable.readVector((DataInput)in);
    }

    static enum ReplacementPolicy {
        FIFO,
        FAIR,
        RANDOM;

    }
}

