/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spring.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.SelectorType;
import org.springframework.stereotype.Component;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Component
public @interface ExtRocketMQConsumerConfiguration {
    public static final String NAME_SERVER_PLACEHOLDER = "${rocketmq.name-server:}";
    public static final String GROUP_PLACEHOLDER = "${rocketmq.consumer.group:}";
    public static final String TOPIC_PLACEHOLDER = "${rocketmq.consumer.topic:}";
    public static final String ACCESS_CHANNEL_PLACEHOLDER = "${rocketmq.access-channel:}";
    public static final String ACCESS_KEY_PLACEHOLDER = "${rocketmq.consumer.access-key:}";
    public static final String SECRET_KEY_PLACEHOLDER = "${rocketmq.consumer.secret-key:}";
    public static final String TRACE_TOPIC_PLACEHOLDER = "${rocketmq.consumer.customized-trace-topic:}";

    public String value() default "";

    public String nameServer() default "${rocketmq.name-server:}";

    public String accessChannel() default "${rocketmq.access-channel:}";

    public String group() default "${rocketmq.consumer.group:}";

    public String topic() default "${rocketmq.consumer.topic:}";

    public MessageModel messageModel() default MessageModel.CLUSTERING;

    public SelectorType selectorType() default SelectorType.TAG;

    public String selectorExpression() default "*";

    public String accessKey() default "${rocketmq.consumer.access-key:}";

    public String secretKey() default "${rocketmq.consumer.secret-key:}";

    public int pullBatchSize() default 10;

    public boolean enableMsgTrace() default false;

    public String customizedTraceTopic() default "${rocketmq.consumer.customized-trace-topic:}";
}

