/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.CookieStore;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Phaser;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.V2RequestSupport;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.AuthenticationStoreHolder;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.HttpClientBuilderFactory;
import org.apache.solr.client.solrj.impl.HttpListenerFactory;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.impl.NoOpResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.request.V2Request;
import org.apache.solr.client.solrj.util.AsyncListener;
import org.apache.solr.client.solrj.util.Cancellable;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.Utils;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProtocolHandlers;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.Socks4Proxy;
import org.eclipse.jetty.client.api.AuthenticationStore;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.client.util.FormRequestContent;
import org.eclipse.jetty.client.util.InputStreamRequestContent;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.client.util.MultiPartRequestContent;
import org.eclipse.jetty.client.util.OutputStreamRequestContent;
import org.eclipse.jetty.client.util.StringRequestContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.HttpClientTransportOverHTTP2;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Http2SolrClient
extends SolrClient {
    public static final String REQ_PRINCIPAL_KEY = "solr-req-principal";
    private static volatile SSLConfig defaultSSLConfig;
    private static final Logger log;
    private static final String AGENT;
    private static final Charset FALLBACK_CHARSET;
    private static final String DEFAULT_PATH = "/select";
    private static final List<String> errPath;
    private final HttpClient httpClient;
    private Set<String> urlParamNames;
    private final long idleTimeoutMillis;
    private final long requestTimeoutMillis;
    private ResponseParser parser = new BinaryResponseParser();
    private Set<String> defaultParserMimeTypes;
    protected RequestWriter requestWriter = new BinaryRequestWriter();
    private List<HttpListenerFactory> listenerFactory = new ArrayList<HttpListenerFactory>();
    private final AsyncTracker asyncTracker = new AsyncTracker();
    private final String serverBaseUrl;
    private final boolean closeClient;
    private ExecutorService executor;
    private boolean shutdownExecutor;
    final String basicAuthAuthorizationStr;
    private AuthenticationStoreHolder authenticationStore;
    private static final Exception CANCELLED_EXCEPTION;
    private static final Cancellable FAILED_MAKING_REQUEST_CANCELLABLE;

    protected Http2SolrClient(String serverBaseUrl, Builder builder) {
        if (serverBaseUrl != null) {
            if (!serverBaseUrl.equals("/") && serverBaseUrl.endsWith("/")) {
                serverBaseUrl = serverBaseUrl.substring(0, serverBaseUrl.length() - 1);
            }
            if (serverBaseUrl.startsWith("//")) {
                serverBaseUrl = serverBaseUrl.substring(1, serverBaseUrl.length());
            }
            this.serverBaseUrl = serverBaseUrl;
        } else {
            this.serverBaseUrl = null;
        }
        this.idleTimeoutMillis = builder.idleTimeoutMillis;
        if (builder.httpClient != null) {
            this.httpClient = builder.httpClient;
            this.closeClient = false;
        } else {
            this.httpClient = this.createHttpClient(builder);
            this.closeClient = true;
        }
        this.basicAuthAuthorizationStr = builder.basicAuthAuthorizationStr;
        if (builder.requestWriter != null) {
            this.requestWriter = builder.requestWriter;
        }
        if (builder.responseParser != null) {
            this.parser = builder.responseParser;
        }
        this.updateDefaultMimeTypeForParser();
        this.requestTimeoutMillis = builder.requestTimeoutMillis != null ? builder.requestTimeoutMillis : -1L;
        this.httpClient.setFollowRedirects(Boolean.TRUE.equals(builder.followRedirects));
        this.urlParamNames = builder.urlParamNames != null ? builder.urlParamNames : Set.of();
        assert (ObjectReleaseTracker.track(this));
    }

    public void addListenerFactory(HttpListenerFactory factory) {
        this.listenerFactory.add(factory);
    }

    HttpClient getHttpClient() {
        return this.httpClient;
    }

    ProtocolHandlers getProtocolHandlers() {
        return this.httpClient.getProtocolHandlers();
    }

    private HttpClient createHttpClient(Builder builder) {
        HttpClient httpClient;
        this.executor = builder.executor;
        if (this.executor == null) {
            BlockingArrayQueue queue = new BlockingArrayQueue(256, 256);
            this.executor = new ExecutorUtil.MDCAwareThreadPoolExecutor(32, 256, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)queue, new SolrNamedThreadFactory("h2sc"));
            this.shutdownExecutor = true;
        } else {
            this.shutdownExecutor = false;
        }
        SslContextFactory.Client sslContextFactory = builder.sslConfig == null ? Http2SolrClient.getDefaultSslContextFactory() : builder.sslConfig.createClientContextFactory();
        ClientConnector clientConnector = new ClientConnector();
        clientConnector.setReuseAddress(true);
        clientConnector.setSslContextFactory(sslContextFactory);
        clientConnector.setSelectors(2);
        if (builder.useHttp1_1) {
            if (log.isDebugEnabled()) {
                log.debug("Create Http2SolrClient with HTTP/1.1 transport");
            }
            HttpClientTransportOverHTTP transport = new HttpClientTransportOverHTTP(clientConnector);
            httpClient = new HttpClient((HttpClientTransport)transport);
            if (builder.maxConnectionsPerHost != null) {
                httpClient.setMaxConnectionsPerDestination(builder.maxConnectionsPerHost.intValue());
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Create Http2SolrClient with HTTP/2 transport");
            }
            HTTP2Client http2client = new HTTP2Client(clientConnector);
            HttpClientTransportOverHTTP2 transport = new HttpClientTransportOverHTTP2(http2client);
            httpClient = new HttpClient((HttpClientTransport)transport);
            httpClient.setMaxConnectionsPerDestination(4);
        }
        httpClient.setExecutor((Executor)this.executor);
        httpClient.setStrictEventOrdering(false);
        httpClient.setConnectBlocking(true);
        httpClient.setFollowRedirects(false);
        httpClient.setMaxRequestsQueuedPerDestination(this.asyncTracker.getMaxRequestsQueuedPerDestination());
        httpClient.setUserAgentField(new HttpField(HttpHeader.USER_AGENT, AGENT));
        httpClient.setIdleTimeout(this.idleTimeoutMillis);
        if (builder.cookieStore != null) {
            httpClient.setCookieStore(builder.cookieStore);
        }
        this.authenticationStore = new AuthenticationStoreHolder();
        httpClient.setAuthenticationStore((AuthenticationStore)this.authenticationStore);
        httpClient.setConnectTimeout(builder.connectionTimeoutMillis.longValue());
        this.setupProxy(builder, httpClient);
        try {
            httpClient.start();
        }
        catch (Exception e) {
            this.close();
            throw new RuntimeException(e);
        }
        return httpClient;
    }

    private void setupProxy(Builder builder, HttpClient httpClient) {
        Socks4Proxy proxy;
        if (builder.proxyHost == null) {
            return;
        }
        Origin.Address address = new Origin.Address(builder.proxyHost, builder.proxyPort);
        if (builder.proxyIsSocks4) {
            proxy = new Socks4Proxy(address, builder.proxyIsSecure);
        } else {
            Origin.Protocol protocol;
            if (builder.useHttp1_1) {
                protocol = HttpClientTransportOverHTTP.HTTP11;
            } else {
                String protocolName = builder.proxyIsSecure ? "h2" : "h2c";
                protocol = new Origin.Protocol(List.of(protocolName), false);
            }
            proxy = new HttpProxy(address, builder.proxyIsSecure, protocol);
        }
        httpClient.getProxyConfiguration().addProxy((ProxyConfiguration.Proxy)proxy);
    }

    @Override
    public void close() {
        this.asyncTracker.waitForComplete();
        try {
            if (this.closeClient) {
                this.httpClient.stop();
                this.httpClient.destroy();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception on closing client", e);
        }
        finally {
            if (this.shutdownExecutor) {
                ExecutorUtil.shutdownAndAwaitTermination(this.executor);
            }
        }
        assert (ObjectReleaseTracker.release(this));
    }

    public void setAuthenticationStore(AuthenticationStore authenticationStore) {
        this.authenticationStore.updateAuthenticationStore(authenticationStore);
    }

    public boolean isV2ApiRequest(SolrRequest<?> request) {
        return request instanceof V2Request || request.getPath().contains("/____v2");
    }

    public long getIdleTimeout() {
        return this.idleTimeoutMillis;
    }

    public OutStream initOutStream(String baseUrl, UpdateRequest updateRequest, String collection) throws IOException {
        String contentType = this.requestWriter.getUpdateContentType();
        ModifiableSolrParams origParams = new ModifiableSolrParams(updateRequest.getParams());
        ModifiableSolrParams requestParams = new ModifiableSolrParams(origParams);
        requestParams.set("wt", this.parser.getWriterType());
        requestParams.set("version", this.parser.getVersion());
        Object basePath = baseUrl;
        if (collection != null) {
            basePath = (String)basePath + "/" + collection;
        }
        if (!((String)basePath).endsWith("/")) {
            basePath = (String)basePath + "/";
        }
        OutputStreamRequestContent content = new OutputStreamRequestContent(contentType);
        Request postRequest = this.httpClient.newRequest((String)basePath + "update" + requestParams.toQueryString()).method(HttpMethod.POST).body((Request.Content)content);
        this.decorateRequest(postRequest, updateRequest, false);
        InputStreamReleaseTrackingResponseListener responseListener = new InputStreamReleaseTrackingResponseListener();
        postRequest.send((Response.CompleteListener)responseListener);
        boolean isXml = "application/xml; charset=UTF-8".equals(this.requestWriter.getUpdateContentType());
        OutStream outStream = new OutStream(collection, origParams, content, responseListener, isXml);
        if (isXml) {
            outStream.write("<stream>".getBytes(FALLBACK_CHARSET));
        }
        return outStream;
    }

    public void send(OutStream outStream, SolrRequest<?> req, String collection) throws IOException {
        SolrParams params;
        assert (outStream.belongToThisStream(req, collection));
        this.requestWriter.write(req, outStream.content.getOutputStream());
        if (outStream.isXml && (params = req.getParams()) != null) {
            String fmt = null;
            if (params.getBool("optimize", false)) {
                fmt = "<optimize waitSearcher=\"%s\" />";
            } else if (params.getBool("commit", false)) {
                fmt = "<commit waitSearcher=\"%s\" />";
            }
            if (fmt != null) {
                byte[] content = String.format(Locale.ROOT, fmt, "" + params.getBool("waitSearcher", false)).getBytes(FALLBACK_CHARSET);
                outStream.write(content);
            }
        }
        outStream.flush();
    }

    public Cancellable asyncRequest(SolrRequest<?> solrReq, String collection, final AsyncListener<NamedList<Object>> asyncListener) {
        Request req;
        final MDCCopyHelper mdcCopyHelper = new MDCCopyHelper();
        final SolrRequest<?> solrRequest = this.unwrapV2Request(solrReq);
        try {
            final String url = this.getRequestPath(solrRequest, collection);
            InputStreamReleaseTrackingResponseListener listener = new InputStreamReleaseTrackingResponseListener(){

                public void onHeaders(Response response) {
                    super.onHeaders(response);
                    Http2SolrClient.this.executor.execute(() -> {
                        InputStream is = this.getInputStream();
                        try {
                            NamedList<Object> body = Http2SolrClient.this.processErrorsAndResponse(solrRequest, response, is, url);
                            mdcCopyHelper.onBegin(null);
                            log.debug("response processing success");
                            asyncListener.onSuccess(body);
                        }
                        catch (BaseHttpSolrClient.RemoteSolrException e) {
                            if (SolrException.getRootCause(e) != CANCELLED_EXCEPTION) {
                                mdcCopyHelper.onBegin(null);
                                log.debug("response processing failed", (Throwable)e);
                                asyncListener.onFailure(e);
                            }
                        }
                        catch (SolrServerException e) {
                            mdcCopyHelper.onBegin(null);
                            log.debug("response processing failed", (Throwable)e);
                            asyncListener.onFailure(e);
                        }
                        finally {
                            log.debug("response processing completed");
                            mdcCopyHelper.onComplete(null);
                        }
                    });
                }

                public void onFailure(Response response, Throwable failure) {
                    super.onFailure(response, failure);
                    if (failure != CANCELLED_EXCEPTION) {
                        asyncListener.onFailure(new SolrServerException(failure.getMessage(), failure));
                    }
                }
            };
            req = this.makeRequestAndSend(solrRequest, url, listener, true);
        }
        catch (IOException | SolrServerException e) {
            asyncListener.onFailure(e);
            return FAILED_MAKING_REQUEST_CANCELLABLE;
        }
        return () -> req.abort((Throwable)CANCELLED_EXCEPTION);
    }

    @Override
    public NamedList<Object> request(SolrRequest<?> solrRequest, String collection) throws SolrServerException, IOException {
        solrRequest = this.unwrapV2Request(solrRequest);
        String url = this.getRequestPath(solrRequest, collection);
        Throwable abortCause = null;
        Request req = null;
        try {
            InputStreamReleaseTrackingResponseListener listener = new InputStreamReleaseTrackingResponseListener();
            req = this.makeRequestAndSend(solrRequest, url, listener, false);
            Response response = listener.get(this.idleTimeoutMillis, TimeUnit.MILLISECONDS);
            url = req.getURI().toString();
            InputStream is = listener.getInputStream();
            NamedList<Object> namedList = this.processErrorsAndResponse(solrRequest, response, is, url);
            return namedList;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            abortCause = e;
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new SolrServerException("Timeout occurred while waiting response from server at: " + url, e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            abortCause = cause;
            if (cause instanceof ConnectException) {
                throw new SolrServerException("Server refused connection at: " + url, cause);
            }
            if (cause instanceof SolrServerException) {
                throw (SolrServerException)cause;
            }
            if (cause instanceof IOException) {
                throw new SolrServerException("IOException occurred when talking to server at: " + url, cause);
            }
            throw new SolrServerException(cause.getMessage(), cause);
        }
        catch (RuntimeException | SolrServerException sse) {
            abortCause = sse;
            throw sse;
        }
        finally {
            if (abortCause != null && req != null) {
                req.abort(abortCause);
            }
        }
    }

    private NamedList<Object> processErrorsAndResponse(SolrRequest<?> solrRequest, Response response, InputStream is, String urlExceptionMessage) throws SolrServerException {
        ResponseParser parser = solrRequest.getResponseParser() == null ? this.parser : solrRequest.getResponseParser();
        String contentType = response.getHeaders().get(HttpHeader.CONTENT_TYPE);
        String mimeType = null;
        String encoding = null;
        if (contentType != null) {
            mimeType = MimeTypes.getContentTypeWithoutCharset((String)contentType);
            encoding = MimeTypes.getCharsetFromContentType((String)contentType);
        }
        return this.processErrorsAndResponse(response, parser, is, mimeType, encoding, this.isV2ApiRequest(solrRequest), urlExceptionMessage);
    }

    private void setBasicAuthHeader(SolrRequest<?> solrRequest, Request req) {
        if (solrRequest.getBasicAuthUser() != null && solrRequest.getBasicAuthPassword() != null) {
            String encoded = Http2SolrClient.basicAuthCredentialsToAuthorizationString(solrRequest.getBasicAuthUser(), solrRequest.getBasicAuthPassword());
            req.headers(headers -> headers.put("Authorization", encoded));
        } else if (this.basicAuthAuthorizationStr != null) {
            req.headers(headers -> headers.put("Authorization", this.basicAuthAuthorizationStr));
        }
    }

    static String basicAuthCredentialsToAuthorizationString(String user, String pass) {
        String userPass = user + ":" + pass;
        return "Basic " + Base64.getEncoder().encodeToString(userPass.getBytes(FALLBACK_CHARSET));
    }

    private void decorateRequest(Request req, SolrRequest<?> solrRequest, boolean isAsync) {
        Map<String, String> headers2;
        req.headers(headers -> headers.remove(HttpHeader.ACCEPT_ENCODING));
        if (this.requestTimeoutMillis > 0L) {
            req.timeout(this.requestTimeoutMillis, TimeUnit.MILLISECONDS);
        } else {
            req.timeout(this.idleTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        if (solrRequest.getUserPrincipal() != null) {
            req.attribute(REQ_PRINCIPAL_KEY, (Object)solrRequest.getUserPrincipal());
        }
        this.setBasicAuthHeader(solrRequest, req);
        for (HttpListenerFactory factory : this.listenerFactory) {
            HttpListenerFactory.RequestResponseListener listener = factory.get();
            listener.onQueued(req);
            req.onRequestBegin((Request.BeginListener)listener);
            req.onComplete((Response.CompleteListener)listener);
        }
        if (isAsync) {
            req.onRequestQueued(this.asyncTracker.queuedListener);
            req.onComplete(this.asyncTracker.completeListener);
        }
        if ((headers2 = solrRequest.getHeaders()) != null) {
            req.headers(h -> headers2.entrySet().stream().forEach(entry -> h.add((String)entry.getKey(), (String)entry.getValue())));
        }
    }

    private String changeV2RequestEndpoint(String basePath) throws MalformedURLException {
        URL oldURL = new URL(basePath);
        String newPath = oldURL.getPath().replaceFirst("/solr", "/api");
        return new URL(oldURL.getProtocol(), oldURL.getHost(), oldURL.getPort(), newPath).toString();
    }

    private SolrRequest<?> unwrapV2Request(SolrRequest<?> solrRequest) {
        if (solrRequest.getBasePath() == null && this.serverBaseUrl == null) {
            throw new IllegalArgumentException("Destination node is not provided!");
        }
        if (solrRequest instanceof V2RequestSupport) {
            return ((V2RequestSupport)((Object)solrRequest)).getV2Request();
        }
        return solrRequest;
    }

    private String getRequestPath(SolrRequest<?> solrRequest, String collection) throws MalformedURLException {
        String path;
        Object basePath;
        Object object = basePath = solrRequest.getBasePath() == null ? this.serverBaseUrl : solrRequest.getBasePath();
        if (collection != null) {
            basePath = (String)basePath + "/" + collection;
        }
        if (solrRequest instanceof V2Request) {
            basePath = System.getProperty("solr.v2RealPath") == null ? this.changeV2RequestEndpoint((String)basePath) : this.serverBaseUrl + "/____v2";
        }
        if ((path = this.requestWriter.getPath(solrRequest)) == null || !path.startsWith("/")) {
            path = DEFAULT_PATH;
        }
        return (String)basePath + path;
    }

    private Request makeRequestAndSend(SolrRequest<?> solrRequest, String url, InputStreamResponseListener listener, boolean isAsync) throws IOException, SolrServerException {
        ResponseParser parser = solrRequest.getResponseParser() == null ? this.parser : solrRequest.getResponseParser();
        ModifiableSolrParams wparams = new ModifiableSolrParams(solrRequest.getParams());
        wparams.set("wt", parser.getWriterType());
        wparams.set("version", parser.getVersion());
        if (SolrRequest.METHOD.GET == solrRequest.getMethod()) {
            Collection<ContentStream> streams;
            RequestWriter.ContentWriter contentWriter = this.requestWriter.getContentWriter(solrRequest);
            Collection<ContentStream> collection = streams = contentWriter == null ? this.requestWriter.getContentStreams(solrRequest) : null;
            if (contentWriter != null || streams != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "GET can't send streams!");
            }
            Request r = this.httpClient.newRequest(url + wparams.toQueryString()).method(HttpMethod.GET);
            this.decorateRequest(r, solrRequest, isAsync);
            r.send((Response.CompleteListener)listener);
            return r;
        }
        if (SolrRequest.METHOD.DELETE == solrRequest.getMethod()) {
            Request r = this.httpClient.newRequest(url + wparams.toQueryString()).method(HttpMethod.DELETE);
            this.decorateRequest(r, solrRequest, isAsync);
            r.send((Response.CompleteListener)listener);
            return r;
        }
        if (SolrRequest.METHOD.POST == solrRequest.getMethod() || SolrRequest.METHOD.PUT == solrRequest.getMethod()) {
            HttpMethod method;
            RequestWriter.ContentWriter contentWriter = this.requestWriter.getContentWriter(solrRequest);
            Collection<ContentStream> streams = contentWriter == null ? this.requestWriter.getContentStreams(solrRequest) : null;
            boolean isMultipart = false;
            if (streams != null) {
                boolean hasNullStreamName = false;
                hasNullStreamName = streams.stream().anyMatch(cs -> cs.getName() == null);
                isMultipart = !hasNullStreamName && streams.size() > 1;
            }
            HttpMethod httpMethod = method = SolrRequest.METHOD.POST == solrRequest.getMethod() ? HttpMethod.POST : HttpMethod.PUT;
            if (contentWriter != null) {
                OutputStreamRequestContent content = new OutputStreamRequestContent(contentWriter.getContentType());
                Request r = this.httpClient.newRequest(url + wparams.toQueryString()).method(method).body((Request.Content)content);
                this.decorateRequest(r, solrRequest, isAsync);
                r.send((Response.CompleteListener)listener);
                try (OutputStream output = content.getOutputStream();){
                    contentWriter.write(output);
                }
                return r;
            }
            if (streams == null || isMultipart) {
                ModifiableSolrParams queryParams = this.calculateQueryParams(this.urlParamNames, wparams);
                queryParams.add(this.calculateQueryParams(solrRequest.getQueryParams(), wparams));
                Request req = this.httpClient.newRequest(url + queryParams.toQueryString()).method(method);
                Request r = this.fillContentStream(req, streams, wparams, isMultipart);
                this.decorateRequest(r, solrRequest, isAsync);
                r.send((Response.CompleteListener)listener);
                return r;
            }
            ContentStream contentStream = streams.iterator().next();
            InputStreamRequestContent content = new InputStreamRequestContent(contentStream.getContentType(), contentStream.getStream());
            Request r = this.httpClient.newRequest(url + wparams.toQueryString()).method(method).body((Request.Content)content);
            this.decorateRequest(r, solrRequest, isAsync);
            r.send((Response.CompleteListener)listener);
            return r;
        }
        throw new SolrServerException("Unsupported method: " + solrRequest.getMethod());
    }

    private Request fillContentStream(Request req, Collection<ContentStream> streams, ModifiableSolrParams wparams, boolean isMultipart) throws IOException {
        if (isMultipart) {
            try (MultiPartRequestContent content = new MultiPartRequestContent();){
                Iterator<String> iter = wparams.getParameterNamesIterator();
                while (iter.hasNext()) {
                    String key = iter.next();
                    String[] vals = wparams.getParams(key);
                    if (vals == null) continue;
                    for (String val : vals) {
                        content.addFieldPart(key, (Request.Content)new StringRequestContent(val), null);
                    }
                }
                if (streams != null) {
                    for (ContentStream contentStream : streams) {
                        String name;
                        String contentType = contentStream.getContentType();
                        if (contentType == null) {
                            contentType = "multipart/form-data";
                        }
                        if ((name = contentStream.getName()) == null) {
                            name = "";
                        }
                        HttpFields.Mutable fields = HttpFields.build((int)1);
                        fields.add(HttpHeader.CONTENT_TYPE, contentType);
                        content.addFilePart(name, contentStream.getName(), (Request.Content)new InputStreamRequestContent(contentStream.getStream()), (HttpFields)fields);
                    }
                }
                req.body((Request.Content)content);
            }
        } else {
            Fields fields = new Fields();
            Iterator<String> iter = wparams.getParameterNamesIterator();
            while (iter.hasNext()) {
                String key = iter.next();
                String[] vals = wparams.getParams(key);
                if (vals == null) continue;
                for (String val : vals) {
                    fields.add(key, val);
                }
            }
            req.body((Request.Content)new FormRequestContent(fields, FALLBACK_CHARSET));
        }
        return req;
    }

    private boolean wantStream(ResponseParser processor) {
        return processor == null || processor instanceof InputStreamResponseParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamedList<Object> processErrorsAndResponse(Response response, ResponseParser processor, InputStream is, String mimeType, String encoding, boolean isV2Api, String urlExceptionMessage) throws SolrServerException {
        Object error;
        NamedList<Object> rsp;
        boolean shouldClose = true;
        int httpStatus = response.getStatus();
        switch (httpStatus) {
            case 200: 
            case 400: 
            case 409: {
                break;
            }
            case 301: 
            case 302: {
                if (this.httpClient.isFollowRedirects()) break;
                throw new SolrServerException("Server at " + urlExceptionMessage + " sent back a redirect (" + httpStatus + ").");
            }
            default: {
                if (processor != null && mimeType != null) break;
                throw new BaseHttpSolrClient.RemoteSolrException(urlExceptionMessage, httpStatus, "non ok status: " + httpStatus + ", message:" + response.getReason(), null);
            }
        }
        if (this.wantStream(processor)) {
            NamedList<Object> rsp2 = new NamedList<Object>();
            rsp2.add("stream", is);
            rsp2.add("responseStatus", httpStatus);
            shouldClose = false;
            NamedList<Object> namedList = rsp2;
            return namedList;
        }
        this.checkContentType(processor, is, mimeType, encoding, httpStatus, urlExceptionMessage);
        try {
            rsp = processor.processResponse(is, encoding);
        }
        catch (Exception e) {
            throw new BaseHttpSolrClient.RemoteSolrException(urlExceptionMessage, httpStatus, e.getMessage(), e);
        }
        Object object = error = rsp == null ? null : rsp.get("error");
        if (rsp != null && error == null && processor instanceof NoOpResponseParser) {
            error = rsp.get("response");
        }
        if (error != null && String.valueOf(Utils.getObjectByPath(error, true, errPath)).endsWith("ExceptionWithErrObject")) {
            throw BaseHttpSolrClient.RemoteExecutionException.create(urlExceptionMessage, rsp);
        }
        if (httpStatus != 200 && !isV2Api) {
            NamedList<String> metadata = null;
            String reason = null;
            try {
                if (error != null) {
                    Object metadataObj;
                    reason = (String)Utils.getObjectByPath(error, false, Collections.singletonList("msg"));
                    if (reason == null) {
                        reason = (String)Utils.getObjectByPath(error, false, Collections.singletonList("trace"));
                    }
                    if ((metadataObj = Utils.getObjectByPath(error, false, Collections.singletonList("metadata"))) instanceof NamedList) {
                        metadata = (NamedList<String>)metadataObj;
                    } else if (metadataObj instanceof List) {
                        List list = (List)metadataObj;
                        metadata = new NamedList(list.size() / 2);
                        for (int i = 0; i < list.size(); i += 2) {
                            metadata.add((String)list.get(i), (String)list.get(i + 1));
                        }
                    } else if (metadataObj instanceof Map) {
                        metadata = new NamedList<String>((Map)metadataObj);
                    }
                }
            }
            catch (Exception metadataObj) {
                // empty catch block
            }
            if (reason == null) {
                StringBuilder msg = new StringBuilder();
                msg.append(response.getReason()).append("\n").append("request: ").append(response.getRequest().getMethod());
                if (error != null) {
                    msg.append("\n\nError returned:\n").append(error);
                }
                reason = URLDecoder.decode(msg.toString(), FALLBACK_CHARSET);
            }
            BaseHttpSolrClient.RemoteSolrException rss = new BaseHttpSolrClient.RemoteSolrException(urlExceptionMessage, httpStatus, reason, null);
            if (metadata != null) {
                rss.setMetadata(metadata);
            }
            throw rss;
        }
        NamedList<Object> namedList = rsp;
        return namedList;
        finally {
            if (shouldClose) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void checkContentType(ResponseParser processor, InputStream is, String mimeType, String encoding, int httpStatus, String urlExceptionMessage) {
        if (mimeType == null || processor == this.parser && this.defaultParserMimeTypes.contains(mimeType)) {
            return;
        }
        Collection<String> processorSupportedContentTypes = processor.getContentTypes();
        if (processorSupportedContentTypes != null && !processorSupportedContentTypes.isEmpty()) {
            boolean processorAcceptsMimeType = processorSupportedContentTypes.stream().map(ct -> MimeTypes.getContentTypeWithoutCharset((String)ct).trim()).anyMatch(mimeType::equalsIgnoreCase);
            if (!processorAcceptsMimeType) {
                String allSupportedTypes = processorSupportedContentTypes.stream().map(ct -> MimeTypes.getContentTypeWithoutCharset((String)ct).trim().toLowerCase(Locale.ROOT)).collect(Collectors.joining(", "));
                String prefix = "Expected mime type in [" + allSupportedTypes + "] but got " + mimeType + ". ";
                String exceptionEncoding = encoding != null ? encoding : FALLBACK_CHARSET.name();
                try {
                    ByteArrayOutputStream body = new ByteArrayOutputStream();
                    is.transferTo(body);
                    throw new BaseHttpSolrClient.RemoteSolrException(urlExceptionMessage, httpStatus, prefix + body.toString(exceptionEncoding), null);
                }
                catch (IOException e) {
                    throw new BaseHttpSolrClient.RemoteSolrException(urlExceptionMessage, httpStatus, "Could not parse response with encoding " + exceptionEncoding, e);
                }
            }
        }
    }

    @Deprecated
    public void setRequestWriter(RequestWriter requestWriter) {
        this.requestWriter = requestWriter;
    }

    protected RequestWriter getRequestWriter() {
        return this.requestWriter;
    }

    @Deprecated
    public void setFollowRedirects(boolean follow) {
        this.httpClient.setFollowRedirects(follow);
    }

    public String getBaseURL() {
        return this.serverBaseUrl;
    }

    @Deprecated
    public Set<String> getQueryParams() {
        return this.getUrlParamNames();
    }

    public Set<String> getUrlParamNames() {
        return this.urlParamNames;
    }

    @Deprecated
    public void setUrlParamNames(Set<String> urlParamNames) {
        this.urlParamNames = urlParamNames;
    }

    private ModifiableSolrParams calculateQueryParams(Set<String> queryParamNames, ModifiableSolrParams wparams) {
        ModifiableSolrParams queryModParams = new ModifiableSolrParams();
        if (queryParamNames != null) {
            for (String param : queryParamNames) {
                String[] value = wparams.getParams(param);
                if (value == null) continue;
                for (String v : value) {
                    queryModParams.add(param, v);
                }
                wparams.remove(param);
            }
        }
        return queryModParams;
    }

    public ResponseParser getParser() {
        return this.parser;
    }

    @Deprecated
    public void setParser(ResponseParser parser) {
        this.parser = parser;
        this.updateDefaultMimeTypeForParser();
    }

    protected void updateDefaultMimeTypeForParser() {
        this.defaultParserMimeTypes = this.parser.getContentTypes().stream().map(ct -> MimeTypes.getContentTypeWithoutCharset((String)ct).trim().toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
    }

    public static void setDefaultSSLConfig(SSLConfig sslConfig) {
        defaultSSLConfig = sslConfig;
    }

    public static void resetSslContextFactory() {
        defaultSSLConfig = null;
    }

    static SslContextFactory.Client getDefaultSslContextFactory() {
        String checkPeerNameStr = System.getProperty("solr.ssl.checkPeerName");
        boolean sslCheckPeerName = !"false".equalsIgnoreCase(checkPeerNameStr);
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client(!sslCheckPeerName);
        if (null != System.getProperty("javax.net.ssl.keyStore")) {
            sslContextFactory.setKeyStorePath(System.getProperty("javax.net.ssl.keyStore"));
        }
        if (null != System.getProperty("javax.net.ssl.keyStorePassword")) {
            sslContextFactory.setKeyStorePassword(System.getProperty("javax.net.ssl.keyStorePassword"));
        }
        if (null != System.getProperty("javax.net.ssl.keyStoreType")) {
            sslContextFactory.setKeyStoreType(System.getProperty("javax.net.ssl.keyStoreType"));
        }
        if (null != System.getProperty("javax.net.ssl.trustStore")) {
            sslContextFactory.setTrustStorePath(System.getProperty("javax.net.ssl.trustStore"));
        }
        if (null != System.getProperty("javax.net.ssl.trustStorePassword")) {
            sslContextFactory.setTrustStorePassword(System.getProperty("javax.net.ssl.trustStorePassword"));
        }
        if (null != System.getProperty("javax.net.ssl.trustStoreType")) {
            sslContextFactory.setTrustStoreType(System.getProperty("javax.net.ssl.trustStoreType"));
        }
        return sslContextFactory;
    }

    static {
        log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        AGENT = "Solr[" + Http2SolrClient.class.getName() + "] 2.0";
        FALLBACK_CHARSET = StandardCharsets.UTF_8;
        errPath = Arrays.asList("metadata", "error-class");
        CANCELLED_EXCEPTION = new Exception();
        FAILED_MAKING_REQUEST_CANCELLABLE = () -> {};
    }

    private static class InputStreamReleaseTrackingResponseListener
    extends InputStreamResponseListener {
        private InputStreamReleaseTrackingResponseListener() {
        }

        public InputStream getInputStream() {
            return new ObjectReleaseTrackedInputStream(super.getInputStream());
        }

        private static final class ObjectReleaseTrackedInputStream
        extends FilterInputStream {
            public ObjectReleaseTrackedInputStream(InputStream in) {
                super(in);
                assert (ObjectReleaseTracker.track(in));
            }

            @Override
            public void close() throws IOException {
                assert (ObjectReleaseTracker.release(this.in));
                super.close();
            }
        }
    }

    private static class MDCCopyHelper
    extends HttpListenerFactory.RequestResponseListener {
        private final Map<String, String> submitterContext = MDC.getCopyOfContextMap();
        private Map<String, String> threadContext;

        private MDCCopyHelper() {
        }

        @Override
        public void onBegin(Request request) {
            this.threadContext = MDC.getCopyOfContextMap();
            MDCCopyHelper.updateContextMap(this.submitterContext);
        }

        @Override
        public void onComplete(Result result) {
            MDCCopyHelper.updateContextMap(this.threadContext);
        }

        private static void updateContextMap(Map<String, String> context) {
            if (context != null && !context.isEmpty()) {
                MDC.setContextMap(context);
            } else {
                MDC.clear();
            }
        }
    }

    public static class Builder {
        private HttpClient httpClient;
        private SSLConfig sslConfig = defaultSSLConfig;
        private Long idleTimeoutMillis;
        private Long connectionTimeoutMillis;
        private Long requestTimeoutMillis;
        private Integer maxConnectionsPerHost;
        private String basicAuthAuthorizationStr;
        private boolean useHttp1_1 = Boolean.getBoolean("solr.http1");
        private Boolean followRedirects;
        protected String baseSolrUrl;
        private ExecutorService executor;
        protected RequestWriter requestWriter;
        protected ResponseParser responseParser;
        private Set<String> urlParamNames;
        private CookieStore cookieStore = Builder.getDefaultCookieStore();
        private String proxyHost;
        private int proxyPort;
        private boolean proxyIsSocks4;
        private boolean proxyIsSecure;

        public Builder() {
        }

        public Builder(String baseSolrUrl) {
            this.baseSolrUrl = baseSolrUrl;
        }

        public Http2SolrClient build() {
            if (this.idleTimeoutMillis == null || this.idleTimeoutMillis <= 0L) {
                this.idleTimeoutMillis = 600000L;
            }
            if (this.connectionTimeoutMillis == null) {
                this.connectionTimeoutMillis = 60000L;
            }
            Http2SolrClient client = new Http2SolrClient(this.baseSolrUrl, this);
            try {
                this.httpClientBuilderSetup(client);
            }
            catch (RuntimeException e) {
                try {
                    client.close();
                }
                catch (Exception exceptionOnClose) {
                    e.addSuppressed(exceptionOnClose);
                }
                throw e;
            }
            return client;
        }

        private void httpClientBuilderSetup(Http2SolrClient client) {
            String factoryClassName = System.getProperty("solr.httpclient.builder.factory");
            if (factoryClassName != null) {
                HttpClientBuilderFactory factory;
                log.debug("Using Http Builder Factory: {}", (Object)factoryClassName);
                try {
                    factory = Class.forName(factoryClassName).asSubclass(HttpClientBuilderFactory.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException("Unable to instantiate " + Http2SolrClient.class.getName(), e);
                }
                factory.setup(client);
            }
        }

        private static CookieStore getDefaultCookieStore() {
            if (Boolean.getBoolean("solr.http.disableCookies")) {
                return new HttpCookieStore.Empty();
            }
            return null;
        }

        public Builder withHttpClient(Http2SolrClient http2SolrClient) {
            this.httpClient = http2SolrClient.httpClient;
            if (this.basicAuthAuthorizationStr == null) {
                this.basicAuthAuthorizationStr = http2SolrClient.basicAuthAuthorizationStr;
            }
            if (this.followRedirects == null) {
                this.followRedirects = http2SolrClient.httpClient.isFollowRedirects();
            }
            if (this.idleTimeoutMillis == null) {
                this.idleTimeoutMillis = http2SolrClient.idleTimeoutMillis;
            }
            if (this.requestWriter == null) {
                this.requestWriter = http2SolrClient.requestWriter;
            }
            if (this.requestTimeoutMillis == null) {
                this.requestTimeoutMillis = http2SolrClient.requestTimeoutMillis;
            }
            if (this.responseParser == null) {
                this.responseParser = http2SolrClient.parser;
            }
            if (this.urlParamNames == null) {
                this.urlParamNames = http2SolrClient.urlParamNames;
            }
            return this;
        }

        public Builder withRequestWriter(RequestWriter requestWriter) {
            this.requestWriter = requestWriter;
            return this;
        }

        public Builder withResponseParser(ResponseParser responseParser) {
            this.responseParser = responseParser;
            return this;
        }

        public Builder withFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public Builder withExecutor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder withSSLConfig(SSLConfig sslConfig) {
            this.sslConfig = sslConfig;
            return this;
        }

        public Builder withBasicAuthCredentials(String user, String pass) {
            if (!(user == null && pass == null || user != null && pass != null)) {
                throw new IllegalStateException("Invalid Authentication credentials. Either both username and password or none must be provided");
            }
            this.basicAuthAuthorizationStr = Http2SolrClient.basicAuthCredentialsToAuthorizationString(user, pass);
            return this;
        }

        public Builder withTheseParamNamesInTheUrl(Set<String> urlParamNames) {
            this.urlParamNames = urlParamNames;
            return this;
        }

        @Deprecated(since="9.2")
        public Builder maxConnectionsPerHost(int max) {
            this.withMaxConnectionsPerHost(max);
            return this;
        }

        public Builder withMaxConnectionsPerHost(int max) {
            this.maxConnectionsPerHost = max;
            return this;
        }

        @Deprecated(since="9.2")
        public Builder idleTimeout(int idleConnectionTimeout) {
            this.withIdleTimeout(idleConnectionTimeout, TimeUnit.MILLISECONDS);
            return this;
        }

        public Builder withIdleTimeout(long idleConnectionTimeout, TimeUnit unit) {
            this.idleTimeoutMillis = TimeUnit.MILLISECONDS.convert(idleConnectionTimeout, unit);
            return this;
        }

        public Long getIdleTimeoutMillis() {
            return this.idleTimeoutMillis;
        }

        public Builder useHttp1_1(boolean useHttp1_1) {
            this.useHttp1_1 = useHttp1_1;
            return this;
        }

        @Deprecated(since="9.2")
        public Builder connectionTimeout(int connectionTimeout) {
            this.withConnectionTimeout(connectionTimeout, TimeUnit.MILLISECONDS);
            return this;
        }

        public Builder withConnectionTimeout(long connectionTimeout, TimeUnit unit) {
            this.connectionTimeoutMillis = TimeUnit.MILLISECONDS.convert(connectionTimeout, unit);
            return this;
        }

        public Long getConnectionTimeout() {
            return this.connectionTimeoutMillis;
        }

        @Deprecated(since="9.2")
        public Builder requestTimeout(int requestTimeout) {
            this.withRequestTimeout(requestTimeout, TimeUnit.MILLISECONDS);
            return this;
        }

        public Builder withRequestTimeout(long requestTimeout, TimeUnit unit) {
            this.requestTimeoutMillis = TimeUnit.MILLISECONDS.convert(requestTimeout, unit);
            return this;
        }

        public Builder withCookieStore(CookieStore cookieStore) {
            this.cookieStore = cookieStore;
            return this;
        }

        public Builder withProxyConfiguration(String host, int port, boolean isSocks4, boolean isSecure) {
            this.proxyHost = host;
            this.proxyPort = port;
            this.proxyIsSocks4 = isSocks4;
            this.proxyIsSecure = isSecure;
            return this;
        }
    }

    private static class AsyncTracker {
        private static final int MAX_OUTSTANDING_REQUESTS = 1000;
        private final Phaser phaser = new Phaser(1);
        private final Semaphore available = new Semaphore(1000, false);
        private final Request.QueuedListener queuedListener = request -> {
            this.phaser.register();
            try {
                this.available.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        };
        private final Response.CompleteListener completeListener = result -> {
            this.phaser.arriveAndDeregister();
            this.available.release();
        };

        AsyncTracker() {
        }

        int getMaxRequestsQueuedPerDestination() {
            return 3000;
        }

        public void waitForComplete() {
            this.phaser.arriveAndAwaitAdvance();
            this.phaser.arriveAndDeregister();
        }
    }

    public static class OutStream
    implements Closeable {
        private final String origCollection;
        private final ModifiableSolrParams origParams;
        private final OutputStreamRequestContent content;
        private final InputStreamResponseListener responseListener;
        private final boolean isXml;

        public OutStream(String origCollection, ModifiableSolrParams origParams, OutputStreamRequestContent content, InputStreamResponseListener responseListener, boolean isXml) {
            this.origCollection = origCollection;
            this.origParams = origParams;
            this.content = content;
            this.responseListener = responseListener;
            this.isXml = isXml;
        }

        boolean belongToThisStream(SolrRequest<?> solrRequest, String collection) {
            ModifiableSolrParams solrParams = new ModifiableSolrParams(solrRequest.getParams());
            return this.origParams.toNamedList().equals(solrParams.toNamedList()) && Objects.equals(this.origCollection, collection);
        }

        public void write(byte[] b) throws IOException {
            this.content.getOutputStream().write(b);
        }

        public void flush() throws IOException {
            this.content.getOutputStream().flush();
        }

        @Override
        public void close() throws IOException {
            if (this.isXml) {
                this.write("</stream>".getBytes(FALLBACK_CHARSET));
            }
            this.content.getOutputStream().close();
        }

        public InputStreamResponseListener getResponseListener() {
            return this.responseListener;
        }
    }
}

