/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.parquet;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.sys.package$;
import scala.util.matching.Regex;

public final class FileSystemHelper$ {
    public static final FileSystemHelper$ MODULE$;

    static {
        new FileSystemHelper$();
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Path> listFiles(String pathStr, Configuration conf) {
        void var5_5;
        Path origPath = new Path(pathStr);
        FileSystem fs = origPath.getFileSystem(conf);
        if (fs == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ParquetTableOperations: Path ", " is incorrectly formatted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{origPath})));
        }
        Path path = origPath.makeQualified(fs);
        if (fs.exists(path) && fs.getFileStatus(path).isDir()) {
            return (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fs.globStatus(path)).flatMap((Function1)new Serializable(fs){
                public static final long serialVersionUID = 0L;
                private final FileSystem fs$3;

                public final TraversableOnce<FileStatus> apply(FileStatus status) {
                    return status.isDir() ? Predef$.MODULE$.refArrayOps((Object[])this.fs$3.listStatus(status.getPath())) : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{status}));
                }
                {
                    this.fs$3 = fs$3;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)))).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Path apply(FileStatus x$9) {
                    return x$9.getPath();
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ParquetTableOperations: path ", " does not exist or is not a directory"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var5_5})));
    }

    public int findMaxTaskId(String pathStr, Configuration conf) {
        Seq<Path> files = this.listFiles(pathStr, conf);
        Regex nameP = new Regex("part-r-(\\d{1,}).parquet", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"taskid"}));
        Regex hiddenFileP = new Regex("_.*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)files.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Path x$10) {
                return x$10.getName();
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(nameP, hiddenFileP){
            public static final long serialVersionUID = 0L;
            private final Regex nameP$1;
            private final Regex hiddenFileP$1;

            public final int apply(String x0$4) {
                int n;
                String string = x0$4;
                Option option = this.nameP$1.unapplySeq((Object)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                    String taskid = (String)((LinearSeqOptimized)option.get()).apply(0);
                    n = new StringOps(Predef$.MODULE$.augmentString(taskid)).toInt();
                } else {
                    Option option2 = this.hiddenFileP$1.unapplySeq((Object)string);
                    if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(0) == 0) {
                        n = 0;
                    } else {
                        if (string instanceof String) {
                            String string2 = string;
                            throw package$.MODULE$.error(new StringBuilder().append((Object)"ERROR: attempting to append to set of Parquet files and found file").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"that does not match name pattern: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string2}))).toString());
                        }
                        n = 0;
                    }
                }
                return n;
            }
            {
                this.nameP$1 = nameP$1;
                this.hiddenFileP$1 = hiddenFileP$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).reduceOption((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$11, int x$12) {
                return this.apply$mcIII$sp(x$11, x$12);
            }

            public int apply$mcIII$sp(int x$11, int x$12) {
                return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(x$11), x$12);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
    }

    private FileSystemHelper$() {
        MODULE$ = this;
    }
}

