/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.caudexorigo.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraPagination {
    private static final Logger log = LoggerFactory.getLogger(CassandraPagination.class);
    private final Object[] bindArguments;
    private final Session cassandra;
    private final PreparedStatement statement;

    public CassandraPagination(Session cassandra, String statement, List<Object> keys, List<Object> arguments) {
        this(cassandra, statement, keys.toArray(), arguments.toArray());
    }

    public CassandraPagination(Session cassandra, String statement, Object[] keys, Object[] arguments) {
        this.bindArguments = ArrayUtils.addAll((Object[])arguments, (Object[])keys);
        this.cassandra = cassandra;
        this.statement = cassandra.prepare(statement + " LIMIT ?");
    }

    public List<Row> getPageWithOffset(int offset, int limit) {
        Iterator rows = this.cassandra.execute((Statement)this.statement.bind(ArrayUtils.addAll((Object[])this.bindArguments, (Object[])Arrays.asList(limit + offset).toArray()))).iterator();
        int index = 0;
        LinkedList<Row> result = new LinkedList<Row>();
        while (rows.hasNext()) {
            if (index > offset) {
                result.add((Row)rows.next());
            } else {
                rows.next();
            }
            ++index;
        }
        return result;
    }
}

