/*
 * Decompiled with CFR 0.152.
 */
package feed.parser;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.caudexorigo.time.ISO8601;

public class DateParser {
    static String[] date_formats = new String[]{"EEE, d MMM yy kk:mm:ss z", "EEE, d MMM yyyy kk:mm:ss z", "EEE, d MMM yyyy kk:mm z", "EEE MMM  d kk:mm:ss zzz yyyy", "EEE, dd MMMM yyyy kk:mm:ss", "yyyy-MM-dd'T'kk:mm:ss'Z'", "yyyy-MM-dd'T'kk:mm:ssz", "yyyy-MM-dd'T'kk:mm:ss", "yyyy-MM-dd kk:mm:ss", "dd/MM/yyyy kk:mm", "dd-MM-yyyy kk:mm", "dd MMM yy : kk:mm:ss", "EEE, dd MMM yyyy", "dd-MM-yyyy", "yyyy-MM-dd kk:mm:ss.0", "-yy-MM", "-yyMM", "yy-MM-dd", "yyyy-MM-dd", "yyyy-MM", "yyyy-D", "-yyMM", "yyyyMMdd", "yyMMdd", "yyyy", "yyD"};
    private static final ThreadLocal<SimpleDateFormat[]> sdf_local = new ThreadLocal<SimpleDateFormat[]>(){

        @Override
        protected SimpleDateFormat[] initialValue() {
            SimpleDateFormat[] date_formaters = new SimpleDateFormat[date_formats.length];
            for (int i = 0; i < date_formaters.length; ++i) {
                SimpleDateFormat sdf = new SimpleDateFormat(date_formats[i], Locale.US);
                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                date_formaters[i] = sdf;
            }
            return date_formaters;
        }
    };
    private static final ThreadLocal<SimpleDateFormat[]> sdf_pt_local = new ThreadLocal<SimpleDateFormat[]>(){
        private final Locale pt = Locale.forLanguageTag("pt-PT");

        @Override
        protected SimpleDateFormat[] initialValue() {
            SimpleDateFormat[] date_formaters = new SimpleDateFormat[date_formats.length];
            for (int i = 0; i < date_formaters.length; ++i) {
                SimpleDateFormat sdf = new SimpleDateFormat(date_formats[i], this.pt);
                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                date_formaters[i] = sdf;
            }
            return date_formaters;
        }
    };

    public static Date parse(String d) {
        SimpleDateFormat[] date_formaters;
        Date date = null;
        for (SimpleDateFormat formatter : date_formaters = sdf_local.get()) {
            try {
                date = formatter.parse(d);
                break;
            }
            catch (Exception exception) {
            }
        }
        for (SimpleDateFormat formatter : date_formaters = sdf_pt_local.get()) {
            try {
                date = formatter.parse(d);
                break;
            }
            catch (Exception exception) {
            }
        }
        return date;
    }

    public static void main(String[] args) {
        Date d = DateParser.parse("Thu, 01 Dez 2016 11:58:12 GMT");
        if (d != null) {
            System.out.println(ISO8601.format((Date)d));
        } else {
            System.out.println("Invalid date");
        }
    }
}

