/*
 * Decompiled with CFR 0.152.
 */
package feed.parser;

import feed.parser.Enclosure;
import feed.parser.FeedChannel;
import feed.parser.FeedEntry;
import feed.parser.FeedEntryProcessor;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;

public class EnclosureProcessor
implements FeedEntryProcessor {
    private final Enclosure.Type encType;

    public EnclosureProcessor(Enclosure.Type encType) {
        this.encType = encType;
    }

    @Override
    public void process(FeedChannel feed_channel, XMLStreamReader stax_xml_reader) {
        FeedEntry feed_entry = feed_channel.getLastFeedEntry();
        try {
            switch (this.encType) {
                case RSS: {
                    this.rssMedia(stax_xml_reader, feed_entry);
                    break;
                }
                case YAHOO_MEDIA: {
                    this.yahooMedia(stax_xml_reader, feed_entry);
                    break;
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void rssMedia(XMLStreamReader stax_xml_reader, FeedEntry feed_entry) {
        int lenght = this.parse(stax_xml_reader.getAttributeValue("", "lenght"));
        String type = stax_xml_reader.getAttributeValue("", "type");
        String url = stax_xml_reader.getAttributeValue("", "url");
        if (StringUtils.isNotBlank((CharSequence)type) && StringUtils.isNotBlank((CharSequence)url)) {
            Enclosure enclosure = new Enclosure(lenght, type, url);
            feed_entry.setEnclosure(enclosure);
        }
    }

    private void yahooMedia(XMLStreamReader stax_xml_reader, FeedEntry feed_entry) {
        int lenght = 1;
        String type = stax_xml_reader.getAttributeValue("", "type");
        String url = stax_xml_reader.getAttributeValue("", "url");
        if (StringUtils.isNotBlank((CharSequence)type) && StringUtils.isNotBlank((CharSequence)url)) {
            Enclosure enclosure = new Enclosure(lenght, type, url);
            feed_entry.setEnclosure(enclosure);
        }
    }

    private int parse(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Throwable e) {
            return 1;
        }
    }
}

