/*
 * Decompiled with CFR 0.152.
 */
package feed.parser;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import feed.parser.AtomLink;
import feed.parser.FeedEntry;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.text.HtmlStripper;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"link", "title", "description", "language", "categories", "entries"})
@XmlType(propOrder={"link", "title", "description", "language", "atomLink", "categories", "entries"})
public class FeedChannel {
    private final Map<String, String> attr;
    private int index = -1;
    private Set<String> col_category;
    private List<FeedEntry> col_entry;
    private final boolean stripHtml;

    public FeedChannel() {
        this(false);
    }

    public FeedChannel(boolean stripHtml) {
        this.stripHtml = stripHtml;
        this.attr = new HashMap<String, String>();
        this.col_category = new HashSet<String>();
        this.col_entry = new ArrayList<FeedEntry>();
    }

    public void addCategory(String category) {
        if (StringUtils.isNotBlank((CharSequence)category)) {
            this.col_category.add(StringUtils.trim((String)category));
        }
    }

    public void addFeedEntry(FeedEntry feedEntry) {
        feedEntry.setStripHhtml(this.stripHtml);
        this.col_entry.add(feedEntry);
        ++this.index;
    }

    @JsonIgnore
    @XmlElement(name="link", namespace="http://www.w3.org/2005/Atom")
    public AtomLink getAtomLink() {
        return new AtomLink(this.getLink());
    }

    @XmlElement(name="category")
    public Set<String> getCategories() {
        HashSet<String> c = new HashSet<String>();
        c.addAll(this.col_category);
        return c;
    }

    public void setCategories(Set<String> cat) {
        if (cat != null) {
            this.col_category = cat;
        }
    }

    @XmlElement(name="description")
    public String getDescription() {
        String cleanDescription = HtmlStripper.strip((String)StringEscapeUtils.unescapeHtml4((String)this.attr.get("description")));
        return StringUtils.isBlank((CharSequence)cleanDescription) ? null : cleanDescription;
    }

    @XmlElement(name="item")
    public List<FeedEntry> getEntries() {
        ArrayList<FeedEntry> lst = new ArrayList<FeedEntry>();
        lst.addAll(this.col_entry);
        return lst;
    }

    @XmlElement(name="language")
    public String getLanguage() {
        return this.attr.get("language");
    }

    @XmlTransient
    protected FeedEntry getLastFeedEntry() {
        return this.col_entry.get(this.index);
    }

    @XmlElement(name="link")
    public String getLink() {
        return this.attr.get("link");
    }

    protected boolean getStripHtml() {
        return this.stripHtml;
    }

    @XmlElement(name="title")
    public String getTitle() {
        String cleanTitle = HtmlStripper.strip((String)StringEscapeUtils.unescapeHtml4((String)this.attr.get("title")));
        return StringUtils.isBlank((CharSequence)cleanTitle) ? null : cleanTitle;
    }

    public void setAttribute(String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)value)) {
            this.attr.put(key, value);
        }
    }

    public void setDescription(String description) {
        if (StringUtils.isNotBlank((CharSequence)description)) {
            this.attr.put("description", description);
        }
    }

    public void setEntries(List<FeedEntry> lst) {
        if (lst != null) {
            this.col_entry = lst;
        }
    }

    public void setLanguage(String lang) {
        if (StringUtils.isNotBlank((CharSequence)lang)) {
            this.attr.put("language", lang);
        }
    }

    public void setTitle(String title) {
        if (StringUtils.isNotBlank((CharSequence)title)) {
            this.attr.put("title", title);
        }
    }

    public String toString() {
        return String.format("FeedChannel [link=%s, title=%s, categories=%s, description=%s, \n\tentries=%s]", this.getLink(), this.getTitle(), this.getCategories(), this.getDescription(), this.getEntries());
    }
}

