/*
 * Decompiled with CFR 0.152.
 */
package feed.parser;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import feed.parser.DateParser;
import feed.parser.Enclosure;
import feed.parser.Guid;
import feed.parser.ImageMimeTable;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.text.HtmlStripper;
import org.caudexorigo.time.RFC822;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"link", "pubDate", "title", "body", "enclosure", "author", "categories", "guid"})
@XmlType(propOrder={"link", "rssPubDate", "title", "body", "enclosure", "author", "categories", "guid"})
public class FeedEntry {
    private static final Pattern img = Pattern.compile(".*<img.*?src=\"(.*?)\".*?>.*");
    private final Map<String, String> attr;
    private Guid guid;
    private Enclosure enclosure;
    private Set<String> col_category;
    private boolean is_clean_body_init = false;
    private String cleanBody = null;
    private boolean stripHtml;

    public FeedEntry() {
        this(false);
    }

    public FeedEntry(boolean stripHtml) {
        this.stripHtml = stripHtml;
        this.attr = new HashMap<String, String>();
        this.col_category = new HashSet<String>();
    }

    public void addCategory(String category) {
        if (StringUtils.isNotBlank((CharSequence)category)) {
            this.col_category.add(category.trim());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeedEntry other = (FeedEntry)obj;
        return !(this.getLink() == null ? other.getLink() != null : !this.getLink().equals(other.getLink()));
    }

    @XmlElement(name="author")
    public String getAuthor() {
        return StringUtils.trimToNull((String)this.attr.get("author"));
    }

    @XmlElement(name="description")
    public String getBody() {
        if (this.stripHtml) {
            return this.getCleanBody();
        }
        return this.getRawBody();
    }

    @XmlElement(name="category")
    public Set<String> getCategories() {
        HashSet<String> c = new HashSet<String>();
        c.addAll(this.col_category);
        return c;
    }

    private String getCleanBody() {
        if (!this.is_clean_body_init) {
            this.cleanBody = StringUtils.trimToNull((String)HtmlStripper.strip((String)StringEscapeUtils.unescapeHtml4((String)this.getRawBody())));
            this.is_clean_body_init = true;
        }
        return this.cleanBody;
    }

    @XmlElement(name="enclosure")
    public Enclosure getEnclosure() {
        String img_url;
        String img_mtype;
        Matcher m;
        if (this.enclosure == null && this.stripHtml && StringUtils.isNotBlank((CharSequence)this.getRawBody()) && (m = img.matcher(this.getRawBody())).find() && StringUtils.isNotBlank((CharSequence)(img_mtype = ImageMimeTable.getContentType(img_url = m.group(1))))) {
            Enclosure e = new Enclosure(1, img_mtype, img_url);
            return e;
        }
        return this.enclosure;
    }

    @XmlElement(name="guid")
    public Guid getGuid() {
        if (this.guid == null) {
            return new Guid(this.getLink(), true);
        }
        return this.guid;
    }

    @XmlElement(name="link")
    public String getLink() {
        String link = this.p_getLink();
        return link;
    }

    @XmlTransient
    public Date getPubDate() {
        if (StringUtils.isNotBlank((CharSequence)this.attr.get("pubdate"))) {
            return DateParser.parse(this.attr.get("pubdate"));
        }
        return null;
    }

    @JsonIgnore
    @XmlTransient
    public String getRawBody() {
        if (StringUtils.isNotBlank((CharSequence)this.attr.get("content:encoded"))) {
            return this.attr.get("content:encoded");
        }
        if (StringUtils.isNotBlank((CharSequence)this.attr.get("body"))) {
            return this.attr.get("body");
        }
        return null;
    }

    @JsonIgnore
    @XmlElement(name="pubDate")
    public String getRssPubDate() {
        if (this.getPubDate() != null) {
            try {
                return RFC822.format((Date)this.getPubDate());
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    @XmlElement(name="title")
    public String getTitle() {
        String cleanTitle = HtmlStripper.strip((String)StringEscapeUtils.unescapeHtml4((String)this.attr.get("title")));
        return StringUtils.trimToNull((String)cleanTitle);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getLink() == null ? 0 : this.getLink().hashCode());
        return result;
    }

    private String p_getLink() {
        if (StringUtils.isNotBlank((CharSequence)this.attr.get("origlink"))) {
            return this.attr.get("origlink").trim();
        }
        if (StringUtils.isNotBlank((CharSequence)this.attr.get("link"))) {
            return this.attr.get("link").trim();
        }
        if (this.guid != null && this.guid.isPermaLink() && StringUtils.isNotBlank((CharSequence)this.guid.getValue())) {
            return this.guid.getValue().trim();
        }
        return null;
    }

    public void setAttribute(String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)value)) {
            this.attr.put(key, value);
        }
    }

    protected void setAuthor(String author) {
        if (StringUtils.isNotBlank((CharSequence)author)) {
            this.attr.put("author", author);
        }
    }

    protected void setBody(String body) {
        if (StringUtils.isNotBlank((CharSequence)body)) {
            this.attr.put("body", body);
        }
    }

    public void setCategories(Set<String> cat) {
        if (cat != null) {
            this.col_category = cat;
        }
    }

    public void setEnclosure(Enclosure enclosure) {
        this.enclosure = enclosure;
    }

    public void setGuid(Guid guid) {
        if (guid != null) {
            this.guid = guid;
        }
    }

    public void setLink(String link) {
        if (StringUtils.isNotBlank((CharSequence)link)) {
            this.attr.put("link", link);
        }
    }

    public void setPubDate(Date pubdate) {
        if (pubdate != null) {
            try {
                this.attr.put("pubdate", RFC822.format((Date)pubdate));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setTitle(String title) {
        if (StringUtils.isNotBlank((CharSequence)title)) {
            this.attr.put("title", title);
        }
    }

    protected void setStripHhtml(boolean stripHtml) {
        this.stripHtml = stripHtml;
    }

    public String toString() {
        return String.format("\n\tFeedEntry [author=%s, guid=%s, link=%s, categories%s, pubDate=%s, title=%s, body=%s, enclosure=%s]", this.getAuthor(), this.getGuid(), this.getLink(), this.getCategories(), this.getPubDate(), this.getTitle(), this.getBody(), this.getEnclosure());
    }
}

