/*
 * Decompiled with CFR 0.152.
 */
package feed.parser;

import feed.parser.FeedChannel;
import feed.parser.StaxParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.caudexorigo.io.UnsynchronizedByteArrayInputStream;
import org.caudexorigo.io.UnsynchronizedByteArrayOutputStream;
import org.caudexorigo.text.DetectEncoding;

public class FeedParser {
    private final StaxParser staxParser = new StaxParser();

    public FeedChannel parse(Reader reader) {
        return this.staxParser.parse(reader, true, false);
    }

    public FeedChannel parse(Reader reader, boolean failOnError) {
        return this.staxParser.parse(reader, failOnError, false);
    }

    public FeedChannel parse(Reader reader, boolean failOnError, boolean stripHtml) {
        return this.staxParser.parse(reader, failOnError, stripHtml);
    }

    public FeedChannel parse(InputStream stream) {
        return this.parse(stream, true);
    }

    public FeedChannel parse(InputStream stream, boolean failOnError) {
        return this.parse(stream, failOnError, false);
    }

    public FeedChannel parse(InputStream stream, boolean failOnError, boolean stripHtml) {
        try {
            Reader reader = this.buildReader(stream);
            return this.staxParser.parse(reader, failOnError, stripHtml);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private Reader buildReader(InputStream stream) throws IOException, UnsupportedEncodingException {
        int b;
        if (stream.markSupported()) {
            DetectEncoding encDetector = new DetectEncoding("UTF-8");
            stream.mark(512);
            String encoding = encDetector.detect(stream);
            stream.reset();
            encDetector.stripBOM(stream);
            InputStreamReader reader = new InputStreamReader(stream, encoding);
            return reader;
        }
        UnsynchronizedByteArrayOutputStream bout = new UnsynchronizedByteArrayOutputStream();
        while ((b = stream.read()) > -1) {
            bout.write(b);
        }
        Reader r = this.buildReader((InputStream)new UnsynchronizedByteArrayInputStream(bout.toByteArray()));
        bout.close();
        return r;
    }
}

