/*
 * Decompiled with CFR 0.152.
 */
package feed.parser;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class Stack<E>
extends AbstractCollection<E> {
    private ArrayList<E> _list;

    public Stack() {
    }

    public Stack(Collection<E> c) {
        this.addAll(c);
    }

    private List<E> getList() {
        if (this._list == null) {
            this._list = new ArrayList();
        }
        return this._list;
    }

    @Override
    public boolean isEmpty() {
        return this._list == null || this._list.isEmpty();
    }

    public boolean push(E o) {
        return this.getList().add(o);
    }

    public E peek() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        List<E> l = this.getList();
        return l.get(l.size() - 1);
    }

    public void replace(E o) {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        List<E> l = this.getList();
        l.set(l.size() - 1, o);
    }

    public E pop() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        List<E> l = this.getList();
        int lastIndex = l.size() - 1;
        E theValue = l.get(lastIndex);
        l.remove(lastIndex);
        if (l.isEmpty()) {
            this._list = null;
        }
        return theValue;
    }

    public Iterator<E> reverseIterator() {
        if (this.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new ReverseListIterator<E>(this._list);
    }

    @Override
    public boolean add(E o) {
        return this.push(o);
    }

    @Override
    public void clear() {
        this.getList().clear();
    }

    @Override
    public Iterator<E> iterator() {
        if (this.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this._list.iterator();
    }

    @Override
    public int size() {
        return this.getList().size();
    }

    private static final class ReverseListIterator<E>
    implements Iterator<E> {
        private final ListIterator<E> _listIterator;

        public ReverseListIterator(List<E> list) {
            this._listIterator = list.listIterator(list.size());
        }

        @Override
        public boolean hasNext() {
            return this._listIterator.hasPrevious();
        }

        @Override
        public E next() {
            return this._listIterator.previous();
        }

        @Override
        public void remove() {
            this._listIterator.remove();
        }
    }
}

