/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.lang.GroovyClassLoader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformationClass;

public class ASTTransformationCollectorCodeVisitor
extends ClassCodeVisitorSupport {
    private SourceUnit source;
    private ClassNode classNode;
    private GroovyClassLoader transformLoader;
    private static final String[] NONE = new String[0];
    private static final Class[] NO_CLASSES = new Class[0];

    public ASTTransformationCollectorCodeVisitor(SourceUnit source, GroovyClassLoader transformLoader) {
        this.source = source;
        this.transformLoader = transformLoader;
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    public void visitClass(ClassNode klassNode) {
        ClassNode oldClass = this.classNode;
        this.classNode = klassNode;
        super.visitClass(this.classNode);
        this.classNode = oldClass;
    }

    private String[] getTransformClassNames(ClassNode cn) {
        if (!cn.hasClass()) {
            List<AnnotationNode> annotations = cn.getAnnotations();
            AnnotationNode transformAnnotation = null;
            for (AnnotationNode anno : annotations) {
                if (!anno.getClassNode().getName().equals(GroovyASTTransformationClass.class.getName())) continue;
                transformAnnotation = anno;
                break;
            }
            if (transformAnnotation != null) {
                Expression expr2 = transformAnnotation.getMember("value");
                String[] values = null;
                if (expr2 == null) {
                    return NONE;
                }
                if (expr2 instanceof ListExpression) {
                    ListExpression expression = (ListExpression)expr2;
                    List<Expression> expressions = expression.getExpressions();
                    values = new String[expressions.size()];
                    int e = 0;
                    for (Expression expr : expressions) {
                        values[e++] = ((ConstantExpression)expr).getText();
                    }
                } else if (expr2 instanceof ConstantExpression) {
                    values = new String[]{((ConstantExpression)expr2).getText()};
                } else {
                    throw new IllegalStateException("NYI: eclipse doesn't understand this kind of expression in an Ast transform definition: " + expr2 + " (class=" + expr2.getClass().getName() + ")");
                }
                return values;
            }
            return null;
        }
        Annotation transformClassAnnotation = ASTTransformationCollectorCodeVisitor.getTransformClassAnnotation(cn);
        if (transformClassAnnotation == null) {
            return null;
        }
        return this.getTransformClassNames(transformClassAnnotation);
    }

    private Class[] getTransformClasses(ClassNode classNode) {
        if (!classNode.hasClass()) {
            List<AnnotationNode> annotations = classNode.getAnnotations();
            AnnotationNode transformAnnotation = null;
            for (AnnotationNode anno : annotations) {
                if (!anno.getClassNode().getName().equals(GroovyASTTransformationClass.class.getName())) continue;
                transformAnnotation = anno;
                break;
            }
            if (transformAnnotation != null) {
                Expression expr = transformAnnotation.getMember("classes");
                if (expr == null) {
                    return NO_CLASSES;
                }
                Class[] values = NO_CLASSES;
                if (expr instanceof ListExpression) {
                    ArrayList loadedClasses = new ArrayList();
                    ListExpression expression = (ListExpression)expr;
                    List<Expression> expressions = expression.getExpressions();
                    for (Expression oneExpr : expressions) {
                        String classname = ((ClassExpression)oneExpr).getType().getName();
                        try {
                            Class<?> clazz = Class.forName(classname, false, this.transformLoader);
                            loadedClasses.add(clazz);
                        }
                        catch (ClassNotFoundException cnfe) {
                            this.source.getErrorCollector().addError(new SimpleMessage("Ast transform processing, cannot find " + classname, this.source));
                        }
                    }
                    if (loadedClasses.size() != 0) {
                        values = loadedClasses.toArray(new Class[loadedClasses.size()]);
                    }
                    return values;
                }
                throw new RuntimeException("nyi implemented in eclipse: need to support: " + expr + " (class=" + expr.getClass() + ")");
            }
            return null;
        }
        Annotation transformClassAnnotation = ASTTransformationCollectorCodeVisitor.getTransformClassAnnotation(classNode);
        if (transformClassAnnotation == null) {
            return null;
        }
        return this.getTransformClasses(transformClassAnnotation);
    }

    public void visitAnnotations(AnnotatedNode node) {
        super.visitAnnotations(node);
        for (AnnotationNode annotation : node.getAnnotations()) {
            String[] transformClassNames = this.getTransformClassNames(annotation.getClassNode());
            Class[] transformClasses = this.getTransformClasses(annotation.getClassNode());
            if (transformClassNames == null && transformClasses == null) continue;
            if (transformClassNames == null) {
                transformClassNames = NONE;
            }
            if (transformClasses == null) {
                transformClasses = NO_CLASSES;
            }
            this.addTransformsToClassNode(annotation, transformClassNames, transformClasses);
        }
    }

    private void addTransformsToClassNode(AnnotationNode annotation, Annotation transformClassAnnotation) {
        String[] transformClassNames = this.getTransformClassNames(annotation.getClassNode());
        Class[] transformClasses = this.getTransformClasses(transformClassAnnotation);
        this.addTransformsToClassNode(annotation, transformClassNames, transformClasses);
    }

    private void addTransformsToClassNode(AnnotationNode annotation, String[] transformClassNames, Class[] transformClasses) {
        if (transformClassNames.length == 0 && transformClasses.length == 0) {
            this.source.getErrorCollector().addError(new SimpleMessage("@GroovyASTTransformationClass in " + annotation.getClassNode().getName() + " does not specify any transform class names/classes", this.source));
        }
        if (transformClassNames.length > 0 && transformClasses.length > 0) {
            this.source.getErrorCollector().addError(new SimpleMessage("@GroovyASTTransformationClass in " + annotation.getClassNode().getName() + " should specify transforms only by class names or by classes and not by both", this.source));
        }
        Object[] objectArray = transformClassNames;
        int n = transformClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String transformClass = objectArray[n2];
            try {
                Class klass = this.transformLoader.loadClass(transformClass, false, true, false);
                this.verifyClassAndAddTransform(annotation, klass);
            }
            catch (ClassNotFoundException e) {
                this.source.getErrorCollector().addErrorAndContinue(new SimpleMessage("Could not find class for Transformation Processor " + transformClass + " declared by " + annotation.getClassNode().getName(), this.source));
            }
            ++n2;
        }
        objectArray = transformClasses;
        n = transformClasses.length;
        n2 = 0;
        while (n2 < n) {
            Object klass = objectArray[n2];
            this.verifyClassAndAddTransform(annotation, (Class)klass);
            ++n2;
        }
    }

    private void verifyClassAndAddTransform(AnnotationNode annotation, Class klass) {
        if (ASTTransformation.class.isAssignableFrom(klass)) {
            this.classNode.addTransform(klass, annotation);
        } else {
            SimpleMessage sm = new SimpleMessage("Not an ASTTransformation: " + klass.getName() + " declared by " + annotation.getClassNode().getName() + ":  klass=" + klass + " loaderForKlass=" + (klass == null ? null : klass.getClassLoader()) + " ASTTransformation.class loader=" + ASTTransformation.class.getClassLoader(), this.source);
            this.source.getErrorCollector().addError(sm);
        }
    }

    private static Annotation getTransformClassAnnotation(ClassNode annotatedType) {
        if (!annotatedType.isResolved()) {
            return null;
        }
        Annotation[] annotationArray = annotatedType.getTypeClass().getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            if (ann.annotationType().getName().equals(GroovyASTTransformationClass.class.getName())) {
                return ann;
            }
            ++n2;
        }
        return null;
    }

    private String[] getTransformClassNames(Annotation transformClassAnnotation) {
        try {
            Method valueMethod = transformClassAnnotation.getClass().getMethod("value", new Class[0]);
            return (String[])valueMethod.invoke((Object)transformClassAnnotation, new Object[0]);
        }
        catch (Exception e) {
            this.source.addException(e);
            return new String[0];
        }
    }

    private Class[] getTransformClasses(Annotation transformClassAnnotation) {
        try {
            Method classesMethod = transformClassAnnotation.getClass().getMethod("classes", new Class[0]);
            return (Class[])classesMethod.invoke((Object)transformClassAnnotation, new Object[0]);
        }
        catch (Exception e) {
            this.source.addException(e);
            return new Class[0];
        }
    }
}

