/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.integration;

import org.codehaus.jdt.groovy.integration.DefaultLanguageSupport;
import org.codehaus.jdt.groovy.integration.EventHandler;
import org.codehaus.jdt.groovy.integration.ISupplementalIndexer;
import org.codehaus.jdt.groovy.integration.LanguageSupport;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.codeassist.complete.CompletionParser;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.search.indexing.IndexingParser;
import org.eclipse.jdt.internal.core.search.matching.ImportMatchLocatorParser;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocatorParser;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatch;
import org.eclipse.jdt.internal.core.util.Util;
import org.osgi.framework.Bundle;

public class LanguageSupportFactory {
    private static LanguageSupport languageSupport;
    public static final int CommentRecorderParserVariant = 2;

    public static Parser getParser(Object requestor, CompilerOptions compilerOptions, ProblemReporter problemReporter, boolean parseLiteralExpressionsAsConstants, int variant) {
        return LanguageSupportFactory.getLanguageSupport().getParser(requestor, compilerOptions, problemReporter, parseLiteralExpressionsAsConstants, variant);
    }

    public static CompletionParser getCompletionParser(CompilerOptions compilerOptions, ProblemReporter problemReposrter, boolean storeExtraSourceEnds, IProgressMonitor monitor) {
        return LanguageSupportFactory.getLanguageSupport().getCompletionParser(compilerOptions, problemReposrter, storeExtraSourceEnds, monitor);
    }

    public static IndexingParser getIndexingParser(ISourceElementRequestor requestor, IProblemFactory problemFactory, CompilerOptions options, boolean reportLocalDeclarations, boolean optimizeStringLiterals, boolean useSourceJavadocParser) {
        return LanguageSupportFactory.getLanguageSupport().getIndexingParser(requestor, problemFactory, options, reportLocalDeclarations, optimizeStringLiterals, useSourceJavadocParser);
    }

    public static SourceElementParser getSourceElementParser(ISourceElementRequestor requestor, IProblemFactory problemFactory, CompilerOptions options, boolean reportLocalDeclarations, boolean optimizeStringLiterals, boolean useSourceJavadocParser) {
        return LanguageSupportFactory.getLanguageSupport().getSourceElementParser(requestor, problemFactory, options, reportLocalDeclarations, optimizeStringLiterals, useSourceJavadocParser);
    }

    public static MatchLocatorParser getMatchLocatorParser(ProblemReporter problemReporter, MatchLocator locator) {
        return LanguageSupportFactory.getLanguageSupport().getMatchLocatorParserParser(problemReporter, locator);
    }

    public static ImportMatchLocatorParser getImportMatchLocatorParser(ProblemReporter problemReporter, MatchLocator locator) {
        return LanguageSupportFactory.getLanguageSupport().getImportMatchLocatorParserParser(problemReporter, locator);
    }

    public static CompilationUnit newCompilationUnit(PackageFragment parent, String name, WorkingCopyOwner owner) {
        return LanguageSupportFactory.getLanguageSupport().newCompilationUnit(parent, name, owner);
    }

    public static CompilationUnitDeclaration newCompilationUnitDeclaration(ICompilationUnit unit, ProblemReporter problemReporter, CompilationResult compilationResult, int sourceLength) {
        return LanguageSupportFactory.getLanguageSupport().newCompilationUnitDeclaration(unit, problemReporter, compilationResult, sourceLength);
    }

    public static boolean isInterestingProject(IProject project) {
        return LanguageSupportFactory.getLanguageSupport().isInterestingProject(project);
    }

    public static boolean isSourceFile(String fileName, boolean isInterestingProject) {
        return LanguageSupportFactory.getLanguageSupport().isSourceFile(fileName, isInterestingProject);
    }

    public static boolean isInterestingSourceFile(String fileName) {
        return LanguageSupportFactory.getLanguageSupport().isInterestingSourceFile(fileName);
    }

    public static boolean maybePerformDelegatedSearch(PossibleMatch possibleMatch, SearchPattern pattern, SearchRequestor requestor) {
        return LanguageSupportFactory.getLanguageSupport().maybePerformDelegatedSearch(possibleMatch, pattern, requestor);
    }

    public static void filterNonSourceMembers(BinaryType binaryType) {
        LanguageSupportFactory.getLanguageSupport().filterNonSourceMembers(binaryType);
    }

    private static LanguageSupport getLanguageSupport() {
        if (languageSupport == null && (languageSupport = LanguageSupportFactory.tryInstantiate("org.codehaus.jdt.groovy.integration.internal.GroovyLanguageSupport")) == null) {
            languageSupport = new DefaultLanguageSupport();
        }
        return languageSupport;
    }

    private static LanguageSupport tryInstantiate(String className) {
        LanguageSupport instance = null;
        if (className != null && className.length() > 0) {
            try {
                int separator = className.indexOf(58);
                Bundle bundle = null;
                if (separator == -1) {
                    JavaCore javaCore = JavaCore.getJavaCore();
                    if (javaCore == null) {
                        Class<?> clazz = Class.forName(className);
                        return (LanguageSupport)clazz.newInstance();
                    }
                    bundle = javaCore.getBundle();
                } else {
                    String bundleName = className.substring(0, separator);
                    className = className.substring(separator + 1);
                    bundle = Platform.getBundle(bundleName);
                }
                Class<?> c = bundle.loadClass(className);
                instance = (LanguageSupport)c.newInstance();
            }
            catch (ClassNotFoundException e) {
                LanguageSupportFactory.log(e);
            }
            catch (InstantiationException e) {
                LanguageSupportFactory.log(e);
            }
            catch (IllegalAccessException e) {
                LanguageSupportFactory.log(e);
            }
            catch (ClassCastException e) {
                LanguageSupportFactory.log(e);
            }
        }
        return instance;
    }

    private static void log(Exception e) {
        if (JavaCore.getPlugin() == null || JavaCore.getPlugin().getLog() == null) {
            System.err.println("Error creating Groovy language support:");
            e.printStackTrace(System.err);
        } else {
            Util.log(e, "Error creating Groovy language support");
        }
    }

    public static EventHandler getEventHandler() {
        return LanguageSupportFactory.getLanguageSupport().getEventHandler();
    }

    public static IJavaSearchScope expandSearchScope(IJavaSearchScope scope, SearchPattern pattern, SearchRequestor requestor) {
        return LanguageSupportFactory.getLanguageSupport().expandSearchScope(scope, pattern, requestor);
    }

    public static boolean isGroovyLanguageSupportInstalled() {
        return LanguageSupportFactory.getLanguageSupport().getClass().getName().endsWith("GroovyLanguageSupport");
    }

    public static boolean isInterestingBinary(BinaryType type, IBinaryType typeInfo) {
        return LanguageSupportFactory.getLanguageSupport().isInterestingBinary(type, typeInfo);
    }

    public static IJavaElement[] binaryCodeSelect(ClassFile classFile, int offset, int length, WorkingCopyOwner owner) throws JavaModelException {
        return LanguageSupportFactory.getLanguageSupport().binaryCodeSelect(classFile, offset, length, owner);
    }

    public static ISupplementalIndexer getSupplementalIndexer() {
        return LanguageSupportFactory.getLanguageSupport().getSupplementalIndexer();
    }
}

