/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.project.MavenProject;
import org.sonar.api.batch.FileFilter;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.resources.DefaultProjectFileSystem;
import org.sonar.api.resources.Languages;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectFileSystem2
extends DefaultProjectFileSystem {
    private ProjectDefinition def;
    private MavenProject pom;

    public DefaultProjectFileSystem2(Project project, Languages languages, ProjectDefinition def, FileFilter[] fileFilters) {
        super(project, languages, fileFilters);
        this.def = def;
    }

    public DefaultProjectFileSystem2(Project project, Languages languages, ProjectDefinition def, MavenProject pom, FileFilter[] fileFilters) {
        this(project, languages, def, fileFilters);
        this.pom = pom;
    }

    public DefaultProjectFileSystem2(Project project, Languages languages, ProjectDefinition def) {
        this(project, languages, def, new FileFilter[0]);
    }

    public DefaultProjectFileSystem2(Project project, Languages languages, ProjectDefinition def, MavenProject pom) {
        this(project, languages, def, pom, new FileFilter[0]);
    }

    public File getBasedir() {
        return this.def.getBaseDir();
    }

    public File getBuildDir() {
        if (this.pom != null) {
            return this.resolvePath(this.pom.getBuild().getDirectory());
        }
        return new File(this.getSonarWorkingDirectory(), "target");
    }

    public File getBuildOutputDir() {
        if (this.pom != null) {
            return this.resolvePath(this.pom.getBuild().getOutputDirectory());
        }
        if (this.def.getBinaries().isEmpty()) {
            return new File(this.getBuildDir(), "classes");
        }
        return this.resolvePath((String)this.def.getBinaries().get(0));
    }

    public List<File> getSourceDirs() {
        List unfiltered = this.resolvePaths(this.def.getSourceDirs());
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)unfiltered, (Predicate)DIRECTORY_EXISTS));
    }

    @Deprecated
    public DefaultProjectFileSystem addSourceDir(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Can not add null to project source dirs");
        }
        if (this.pom != null) {
            this.pom.getCompileSourceRoots().add(0, dir.getAbsolutePath());
        }
        this.def.addSourceDirs(new String[]{dir.getAbsolutePath()});
        return this;
    }

    public List<File> getTestDirs() {
        List unfiltered = this.resolvePaths(this.def.getTestDirs());
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)unfiltered, (Predicate)DIRECTORY_EXISTS));
    }

    @Deprecated
    public DefaultProjectFileSystem addTestDir(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Can not add null to project test dirs");
        }
        if (this.pom != null) {
            this.pom.getTestCompileSourceRoots().add(0, dir.getAbsolutePath());
        }
        this.def.addTestDirs(new String[]{dir.getAbsolutePath()});
        return this;
    }

    public File getReportOutputDir() {
        if (this.pom != null) {
            return this.resolvePath(this.pom.getReporting().getOutputDirectory());
        }
        return new File(this.getBuildDir(), "site");
    }

    public File getSonarWorkingDirectory() {
        try {
            FileUtils.forceMkdir((File)this.def.getWorkDir());
            return this.def.getWorkDir();
        }
        catch (IOException e) {
            throw new SonarException("Unable to retrieve Sonar working directory.", (Throwable)e);
        }
    }

    protected List<File> getInitialSourceFiles() {
        return this.resolvePaths(this.def.getSourceFiles());
    }

    protected List<File> getInitialTestFiles() {
        return this.resolvePaths(this.def.getTestFiles());
    }

    public void start() {
    }
}

