/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.utils.SonarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MavenProjectConverter {
    private static final String UNABLE_TO_DETERMINE_PROJECT_STRUCTURE_EXCEPTION_MESSAGE = "Unable to determine structure of project. Probably you use Maven Advanced Reactor Options, which is not supported by Sonar and should not be used.";

    public static ProjectDefinition convert(List<MavenProject> poms, MavenProject root) {
        HashMap paths = Maps.newHashMap();
        HashMap defs = Maps.newHashMap();
        try {
            for (MavenProject mavenProject : poms) {
                paths.put(mavenProject.getFile().getCanonicalPath(), mavenProject);
                defs.put(mavenProject, MavenProjectConverter.convert(mavenProject));
            }
            for (Map.Entry entry : paths.entrySet()) {
                MavenProject pom = (MavenProject)entry.getValue();
                for (Object m : pom.getModules()) {
                    String moduleId = (String)m;
                    File modulePath = new File(pom.getBasedir(), moduleId);
                    if (modulePath.exists() && modulePath.isDirectory()) {
                        modulePath = new File(modulePath, "pom.xml");
                    }
                    MavenProject module = (MavenProject)paths.get(modulePath.getCanonicalPath());
                    ProjectDefinition parentProject = (ProjectDefinition)defs.get(pom);
                    ProjectDefinition subProject = (ProjectDefinition)defs.get(module);
                    if (parentProject == null) {
                        throw new IllegalStateException(UNABLE_TO_DETERMINE_PROJECT_STRUCTURE_EXCEPTION_MESSAGE);
                    }
                    if (subProject == null) {
                        throw new IllegalStateException(UNABLE_TO_DETERMINE_PROJECT_STRUCTURE_EXCEPTION_MESSAGE);
                    }
                    parentProject.addSubProject(subProject);
                }
            }
        }
        catch (IOException e) {
            throw new SonarException((Throwable)e);
        }
        ProjectDefinition rootProject = (ProjectDefinition)defs.get(root);
        if (rootProject == null) {
            throw new IllegalStateException(UNABLE_TO_DETERMINE_PROJECT_STRUCTURE_EXCEPTION_MESSAGE);
        }
        return rootProject;
    }

    @VisibleForTesting
    static ProjectDefinition convert(MavenProject pom) {
        String key = pom.getGroupId() + ":" + pom.getArtifactId();
        ProjectDefinition definition = ProjectDefinition.create();
        definition.setProperties(pom.getModel().getProperties()).setKey(key).setVersion(pom.getVersion()).setName(pom.getName()).setDescription(pom.getDescription()).addContainerExtension((Object)pom);
        MavenProjectConverter.convertMavenLinksToProperties(definition, pom);
        MavenProjectConverter.synchronizeFileSystem(pom, definition);
        return definition;
    }

    private static void convertMavenLinksToProperties(ProjectDefinition definition, MavenProject pom) {
        MavenProjectConverter.setPropertyIfNotAlreadyExists(definition, "sonar.links.homepage", pom.getUrl());
        Scm scm = pom.getScm();
        if (scm == null) {
            scm = new Scm();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(definition, "sonar.links.scm", scm.getUrl());
        MavenProjectConverter.setPropertyIfNotAlreadyExists(definition, "sonar.links.scm_dev", scm.getDeveloperConnection());
        CiManagement ci = pom.getCiManagement();
        if (ci == null) {
            ci = new CiManagement();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(definition, "sonar.links.ci", ci.getUrl());
        IssueManagement issues = pom.getIssueManagement();
        if (issues == null) {
            issues = new IssueManagement();
        }
        MavenProjectConverter.setPropertyIfNotAlreadyExists(definition, "sonar.links.issue", issues.getUrl());
    }

    private static void setPropertyIfNotAlreadyExists(ProjectDefinition definition, String propertyKey, String propertyValue) {
        if (StringUtils.isBlank((String)definition.getProperties().getProperty(propertyKey))) {
            definition.setProperty(propertyKey, StringUtils.defaultString((String)propertyValue));
        }
    }

    public static void synchronizeFileSystem(MavenProject pom, ProjectDefinition into) {
        into.setBaseDir(pom.getBasedir());
        into.setWorkDir(new File(MavenProjectConverter.resolvePath(pom.getBuild().getDirectory(), pom.getBasedir()), "sonar"));
        into.setSourceDirs(pom.getCompileSourceRoots().toArray(new String[pom.getCompileSourceRoots().size()]));
        into.setTestDirs(pom.getTestCompileSourceRoots().toArray(new String[pom.getTestCompileSourceRoots().size()]));
    }

    static File resolvePath(String path, File basedir) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            try {
                file = new File(basedir, path).getCanonicalFile();
            }
            catch (IOException e) {
                throw new SonarException("Unable to resolve path '" + path + "'", (Throwable)e);
            }
        }
        return file;
    }

    private MavenProjectConverter() {
    }
}

