/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.CmmnXmlConstants;
import org.flowable.cmmn.converter.export.FlowableListenerExport;
import org.flowable.cmmn.converter.util.CmmnXmlUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.ExtensionElement;

public class CaseExport
implements CmmnXmlConstants {
    public static void writeCase(CmmnModel model, Case caseModel, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("case");
        xtw.writeAttribute("id", caseModel.getId());
        if (StringUtils.isNotEmpty((CharSequence)caseModel.getName())) {
            xtw.writeAttribute("name", caseModel.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)caseModel.getInitiatorVariableName())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "initiatorVariableName", caseModel.getInitiatorVariableName());
        }
        if (!caseModel.getCandidateStarterUsers().isEmpty()) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "candidateStarterUsers", CmmnXmlUtil.convertToDelimitedString(caseModel.getCandidateStarterUsers()));
        }
        if (!caseModel.getCandidateStarterGroups().isEmpty()) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "candidateStarterGroups", CmmnXmlUtil.convertToDelimitedString(caseModel.getCandidateStarterGroups()));
        }
        if (StringUtils.isNotEmpty((CharSequence)caseModel.getDocumentation())) {
            xtw.writeStartElement("documentation");
            xtw.writeCharacters(caseModel.getDocumentation());
            xtw.writeEndElement();
        }
        if (StringUtils.isNotEmpty((CharSequence)caseModel.getStartEventType()) && caseModel.getExtensionElements().get("eventType") == null) {
            ExtensionElement extensionElement = new ExtensionElement();
            extensionElement.setNamespace("http://flowable.org/cmmn");
            extensionElement.setNamespacePrefix("flowable");
            extensionElement.setName("eventType");
            extensionElement.setElementText(caseModel.getStartEventType());
            caseModel.addExtensionElement(extensionElement);
        }
        boolean didWriteExtensionStartElement = CmmnXmlUtil.writeExtensionElements((BaseElement)caseModel, false, model.getNamespaces(), xtw);
        didWriteExtensionStartElement = FlowableListenerExport.writeFlowableListeners(xtw, "caseLifecycleListener", caseModel.getLifecycleListeners(), didWriteExtensionStartElement);
        if (didWriteExtensionStartElement) {
            xtw.writeEndElement();
        }
    }
}

