/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import org.flowable.cmmn.engine.impl.agenda.operation.AbstractChangePlanItemInstanceStateOperation;
import org.flowable.cmmn.engine.impl.history.CmmnHistoryManager;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.ExpressionUtil;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class CreatePlanItemInstanceOperation
extends AbstractChangePlanItemInstanceStateOperation {
    public CreatePlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        super(commandContext, planItemInstanceEntity);
    }

    @Override
    protected void internalExecute() {
        if (ExpressionUtil.hasRepetitionRule(this.planItemInstanceEntity)) {
            this.setRepetitionCounter(this.planItemInstanceEntity, this.getRepetitionCounter(this.planItemInstanceEntity) + 1);
        }
        CmmnHistoryManager cmmnHistoryManager = CommandContextUtil.getCmmnHistoryManager(this.commandContext);
        cmmnHistoryManager.recordPlanItemInstanceCreated(this.planItemInstanceEntity);
        if (this.getNewState().equals("available")) {
            this.planItemInstanceEntity.setLastAvailableTime(this.getCurrentTime(this.commandContext));
            cmmnHistoryManager.recordPlanItemInstanceAvailable(this.planItemInstanceEntity);
        }
    }

    @Override
    public String getNewState() {
        if (this.isEventListenerWithAvailableCondition(this.planItemInstanceEntity.getPlanItem())) {
            return "unavailable";
        }
        return "available";
    }

    @Override
    public String getLifeCycleTransition() {
        return "create";
    }

    @Override
    public String getOperationName() {
        return "[Create plan item]";
    }
}

