/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import org.flowable.cmmn.api.migration.CaseInstanceMigrationDocument;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.migration.CaseInstanceMigrationManager;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class CaseInstanceMigrationCmd
implements Command<Void> {
    protected CmmnEngineConfiguration cmmnEngineConfiguration;
    protected String caseInstanceId;
    protected String caseDefinitionId;
    protected String caseDefinitionKey;
    protected int caseDefinitionVersion;
    protected String caseDefinitionTenantId;
    protected CaseInstanceMigrationDocument caseInstanceMigrationDocument;

    public CaseInstanceMigrationCmd(String caseInstanceId, CaseInstanceMigrationDocument caseInstanceMigrationDocument, CmmnEngineConfiguration cmmnEngineConfiguration) {
        if (caseInstanceId == null) {
            throw new FlowableException("Must specify a case instance id to migrate");
        }
        if (caseInstanceMigrationDocument == null) {
            throw new FlowableException("Must specify a case instance migration document to migrate");
        }
        this.caseInstanceId = caseInstanceId;
        this.caseInstanceMigrationDocument = caseInstanceMigrationDocument;
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public CaseInstanceMigrationCmd(CaseInstanceMigrationDocument caseInstanceMigrationDocument, String caseDefinitionId, CmmnEngineConfiguration cmmnEngineConfiguration) {
        if (caseDefinitionId == null) {
            throw new FlowableException("Must specify a case definition id to migrate");
        }
        if (caseInstanceMigrationDocument == null) {
            throw new FlowableException("Must specify a case instance migration document to migrate");
        }
        this.caseDefinitionId = null;
        this.caseInstanceMigrationDocument = caseInstanceMigrationDocument;
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public CaseInstanceMigrationCmd(String caseDefinitionKey, int caseDefinitionVersion, String caseDefinitionTenantId, CaseInstanceMigrationDocument caseInstanceMigrationDocument, CmmnEngineConfiguration cmmnEngineConfiguration) {
        if (caseDefinitionKey == null) {
            throw new FlowableException("Must specify a case definition id to migrate");
        }
        if (caseDefinitionTenantId == null) {
            throw new FlowableException("Must specify a case definition id to migrate");
        }
        if (caseInstanceMigrationDocument == null) {
            throw new FlowableException("Must specify a case instance migration document to migrate");
        }
        this.caseDefinitionKey = caseDefinitionKey;
        this.caseDefinitionVersion = caseDefinitionVersion;
        this.caseDefinitionTenantId = caseDefinitionTenantId;
        this.caseInstanceMigrationDocument = caseInstanceMigrationDocument;
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public Void execute(CommandContext commandContext) {
        CaseInstanceMigrationManager migrationManager = this.cmmnEngineConfiguration.getCaseInstanceMigrationManager();
        if (this.caseInstanceId != null) {
            migrationManager.migrateCaseInstance(this.caseInstanceId, this.caseInstanceMigrationDocument, commandContext);
        } else if (this.caseDefinitionId != null) {
            migrationManager.migrateCaseInstancesOfCaseDefinition(this.caseDefinitionId, this.caseInstanceMigrationDocument, commandContext);
        } else if (this.caseDefinitionKey != null && this.caseDefinitionVersion >= 0) {
            migrationManager.migrateCaseInstancesOfCaseDefinition(this.caseDefinitionKey, this.caseDefinitionVersion, this.caseDefinitionTenantId, this.caseInstanceMigrationDocument, commandContext);
        } else {
            throw new FlowableException("Cannot migrate case(es), not enough information");
        }
        return null;
    }
}

