/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.flowable.cmmn.converter.CmmnXMLException;
import org.flowable.cmmn.converter.CmmnXmlConverter;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.parser.CmmnActivityBehaviorFactory;
import org.flowable.cmmn.engine.impl.parser.CmmnParseHandlers;
import org.flowable.cmmn.engine.impl.parser.CmmnParseResult;
import org.flowable.cmmn.engine.impl.parser.CmmnParser;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.io.InputStreamProvider;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.util.io.InputStreamSource;
import org.flowable.common.engine.impl.util.io.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmmnParserImpl
implements CmmnParser {
    private final Logger logger = LoggerFactory.getLogger(CmmnParserImpl.class);
    protected CmmnParseHandlers cmmnParseHandlers;
    protected CmmnActivityBehaviorFactory activityBehaviorFactory;
    protected ExpressionManager expressionManager;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CmmnParseResult parse(EngineResource resourceEntity) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(resourceEntity.getBytes());){
            CmmnParseResult cmmnParseResult2 = this.parse(resourceEntity, (StreamSource)new InputStreamSource((InputStream)inputStream));
            this.processDI(cmmnParseResult2.getCmmnModel(), cmmnParseResult2.getAllCaseDefinitions());
            CmmnParseResult cmmnParseResult = cmmnParseResult2;
            return cmmnParseResult;
        }
        catch (IOException e) {
            this.logger.error("Could not read bytes from CMMN resource", (Throwable)e);
            return new CmmnParseResult();
        }
    }

    public CmmnParseResult parse(EngineResource resourceEntity, StreamSource cmmnSource) {
        try {
            boolean enableSafeBpmnXml = false;
            String encoding = null;
            CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration();
            if (cmmnEngineConfiguration != null) {
                enableSafeBpmnXml = cmmnEngineConfiguration.isEnableSafeCmmnXml();
                encoding = cmmnEngineConfiguration.getXmlEncoding();
            }
            CmmnParseResult cmmnParseResult = new CmmnParseResult();
            cmmnParseResult.setResourceEntity(resourceEntity);
            boolean validateCmmnXml = true;
            if (cmmnEngineConfiguration.isDisableCmmnXmlValidation()) {
                validateCmmnXml = false;
            }
            CmmnModel cmmnModel = new CmmnXmlConverter().convertToCmmnModel((InputStreamProvider)cmmnSource, validateCmmnXml, enableSafeBpmnXml, encoding);
            cmmnParseResult.setCmmnModel(cmmnModel);
            this.processCmmnElements(cmmnModel, cmmnParseResult);
            return cmmnParseResult;
        }
        catch (Exception e) {
            if (e instanceof FlowableException) {
                throw (FlowableException)((Object)e);
            }
            if (e instanceof CmmnXMLException) {
                throw (CmmnXMLException)e;
            }
            throw new FlowableException("Error parsing XML", (Throwable)e);
        }
    }

    public void processCmmnElements(CmmnModel cmmnModel, CmmnParseResult parseResult) {
        for (Case caze : cmmnModel.getCases()) {
            this.cmmnParseHandlers.parseElement(this, parseResult, (BaseElement)caze);
        }
    }

    public void processDI(CmmnModel cmmnModel, List<CaseDefinitionEntity> caseDefinitions) {
        if (caseDefinitions.isEmpty()) {
            return;
        }
        if (!cmmnModel.getLocationMap().isEmpty()) {
            ArrayList<String> planModelIds = new ArrayList<String>();
            for (Case caseObject : cmmnModel.getCases()) {
                planModelIds.add(caseObject.getPlanModel().getId());
            }
            for (String cmmnReference : cmmnModel.getLocationMap().keySet()) {
                if (planModelIds.contains(cmmnReference) || cmmnModel.findPlanItem(cmmnReference) != null || cmmnModel.getCriterion(cmmnReference) != null) continue;
                this.logger.warn("Invalid reference in diagram interchange definition: could not find {}", (Object)cmmnReference);
            }
            for (Case caseObject : cmmnModel.getCases()) {
                CaseDefinitionEntity caseDefinition = this.getCaseDefinition(caseObject.getId(), caseDefinitions);
                if (caseDefinition == null) continue;
                caseDefinition.setHasGraphicalNotation(true);
            }
        }
    }

    public CaseDefinitionEntity getCaseDefinition(String caseDefinitionKey, List<CaseDefinitionEntity> caseDefinitions) {
        for (CaseDefinitionEntity caseDefinition : caseDefinitions) {
            if (!caseDefinition.getKey().equals(caseDefinitionKey)) continue;
            return caseDefinition;
        }
        return null;
    }

    public CmmnParseHandlers getCmmnParseHandlers() {
        return this.cmmnParseHandlers;
    }

    public void setCmmnParseHandlers(CmmnParseHandlers cmmnParseHandlers) {
        this.cmmnParseHandlers = cmmnParseHandlers;
    }

    public CmmnActivityBehaviorFactory getActivityBehaviorFactory() {
        return this.activityBehaviorFactory;
    }

    public void setActivityBehaviorFactory(CmmnActivityBehaviorFactory activityBehaviorFactory) {
        this.activityBehaviorFactory = activityBehaviorFactory;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }
}

