/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.impl.persistence.entity.AbstractIdmEngineEntityManager;
import org.flowable.idm.engine.impl.persistence.entity.IdentityInfoEntity;
import org.flowable.idm.engine.impl.persistence.entity.IdentityInfoEntityManager;
import org.flowable.idm.engine.impl.persistence.entity.data.IdentityInfoDataManager;

public class IdentityInfoEntityManagerImpl
extends AbstractIdmEngineEntityManager<IdentityInfoEntity, IdentityInfoDataManager>
implements IdentityInfoEntityManager {
    public IdentityInfoEntityManagerImpl(IdmEngineConfiguration idmEngineConfiguration, IdentityInfoDataManager identityInfoDataManager) {
        super(idmEngineConfiguration, identityInfoDataManager);
    }

    @Override
    public void deleteUserInfoByUserIdAndKey(String userId, String key) {
        IdentityInfoEntity identityInfoEntity = this.findUserInfoByUserIdAndKey(userId, key);
        if (identityInfoEntity != null) {
            this.delete(identityInfoEntity);
        }
    }

    @Override
    public void updateUserInfo(String userId, String userPassword, String type, String key, String value, String accountPassword, Map<String, String> accountDetails) {
        IdentityInfoEntity identityInfoEntity;
        byte[] storedPassword = null;
        if (accountPassword != null) {
            storedPassword = this.encryptPassword(accountPassword, userPassword);
        }
        if ((identityInfoEntity = this.findUserInfoByUserIdAndKey(userId, key)) != null) {
            identityInfoEntity.setValue(value);
            identityInfoEntity.setPasswordBytes(storedPassword);
            ((IdentityInfoDataManager)this.dataManager).update(identityInfoEntity);
            if (accountDetails == null) {
                accountDetails = new HashMap<String, String>();
            }
            HashSet<String> newKeys = new HashSet<String>(accountDetails.keySet());
            List<IdentityInfoEntity> identityInfoDetails = ((IdentityInfoDataManager)this.dataManager).findIdentityInfoDetails(identityInfoEntity.getId());
            for (IdentityInfoEntity identityInfoDetail : identityInfoDetails) {
                String detailKey = identityInfoDetail.getKey();
                newKeys.remove(detailKey);
                String newDetailValue = accountDetails.get(detailKey);
                if (newDetailValue == null) {
                    this.delete(identityInfoDetail);
                    continue;
                }
                identityInfoDetail.setValue(newDetailValue);
            }
            this.insertAccountDetails(identityInfoEntity, accountDetails, newKeys);
        } else {
            identityInfoEntity = (IdentityInfoEntity)((IdentityInfoDataManager)this.dataManager).create();
            identityInfoEntity.setUserId(userId);
            identityInfoEntity.setType(type);
            identityInfoEntity.setKey(key);
            identityInfoEntity.setValue(value);
            identityInfoEntity.setPasswordBytes(storedPassword);
            this.insert(identityInfoEntity, false);
            if (accountDetails != null) {
                this.insertAccountDetails(identityInfoEntity, accountDetails, accountDetails.keySet());
            }
        }
    }

    protected void insertAccountDetails(IdentityInfoEntity identityInfoEntity, Map<String, String> accountDetails, Set<String> keys) {
        for (String newKey : keys) {
            IdentityInfoEntity identityInfoDetail = (IdentityInfoEntity)((IdentityInfoDataManager)this.dataManager).create();
            identityInfoDetail.setParentId(identityInfoEntity.getId());
            identityInfoDetail.setKey(newKey);
            identityInfoDetail.setValue(accountDetails.get(newKey));
            this.insert(identityInfoDetail, false);
        }
    }

    protected byte[] encryptPassword(String accountPassword, String userPassword) {
        return accountPassword.getBytes();
    }

    protected String decryptPassword(byte[] storedPassword, String userPassword) {
        return new String(storedPassword);
    }

    @Override
    public IdentityInfoEntity findUserInfoByUserIdAndKey(String userId, String key) {
        return ((IdentityInfoDataManager)this.dataManager).findUserInfoByUserIdAndKey(userId, key);
    }

    @Override
    public List<IdentityInfoEntity> findIdentityInfoByUserId(String userId) {
        return ((IdentityInfoDataManager)this.dataManager).findIdentityInfoByUserId(userId);
    }

    @Override
    public List<String> findUserInfoKeysByUserIdAndType(String userId, String type) {
        return ((IdentityInfoDataManager)this.dataManager).findUserInfoKeysByUserIdAndType(userId, type);
    }
}

