/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.query.AbstractQuery;
import org.flowable.job.api.Job;
import org.flowable.job.api.JobQuery;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.JobQueryProperty;

public class JobQueryImpl
extends AbstractQuery<JobQuery, Job>
implements JobQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected JobServiceConfiguration jobServiceConfiguration;
    protected String id;
    protected String processInstanceId;
    protected String executionId;
    protected String handlerType;
    protected String processDefinitionId;
    protected String category;
    protected String categoryLike;
    protected String elementId;
    protected String elementName;
    protected String scopeId;
    protected String subScopeId;
    protected String scopeType;
    protected String scopeDefinitionId;
    protected String correlationId;
    protected boolean onlyTimers;
    protected boolean onlyMessages;
    protected Date duedateHigherThan;
    protected Date duedateLowerThan;
    protected Date duedateHigherThanOrEqual;
    protected Date duedateLowerThanOrEqual;
    protected boolean withException;
    protected String exceptionMessage;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected String lockOwner;
    protected boolean onlyLocked;
    protected boolean onlyUnlocked;

    public JobQueryImpl() {
    }

    public JobQueryImpl(CommandContext commandContext, JobServiceConfiguration jobServiceConfiguration) {
        super(commandContext);
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public JobQueryImpl(CommandExecutor commandExecutor, JobServiceConfiguration jobServiceConfiguration) {
        super(commandExecutor);
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public JobQuery jobId(String jobId) {
        if (jobId == null) {
            throw new FlowableIllegalArgumentException("Provided job id is null");
        }
        this.id = jobId;
        return this;
    }

    public JobQueryImpl processInstanceId(String processInstanceId) {
        if (processInstanceId == null) {
            throw new FlowableIllegalArgumentException("Provided process instance id is null");
        }
        this.processInstanceId = processInstanceId;
        return this;
    }

    public JobQueryImpl processDefinitionId(String processDefinitionId) {
        if (processDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Provided process definition id is null");
        }
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public JobQueryImpl category(String category) {
        if (category == null) {
            throw new FlowableIllegalArgumentException("Provided category is null");
        }
        this.category = category;
        return this;
    }

    public JobQueryImpl categoryLike(String categoryLike) {
        if (categoryLike == null) {
            throw new FlowableIllegalArgumentException("Provided categoryLike is null");
        }
        this.categoryLike = categoryLike;
        return this;
    }

    public JobQueryImpl elementId(String elementId) {
        if (elementId == null) {
            throw new FlowableIllegalArgumentException("Provided element id is null");
        }
        this.elementId = elementId;
        return this;
    }

    public JobQueryImpl elementName(String elementName) {
        if (elementName == null) {
            throw new FlowableIllegalArgumentException("Provided element name is null");
        }
        this.elementName = elementName;
        return this;
    }

    public JobQueryImpl scopeId(String scopeId) {
        if (scopeId == null) {
            throw new FlowableIllegalArgumentException("Provided scope id is null");
        }
        this.scopeId = scopeId;
        return this;
    }

    public JobQueryImpl subScopeId(String subScopeId) {
        if (subScopeId == null) {
            throw new FlowableIllegalArgumentException("Provided sub scope id is null");
        }
        this.subScopeId = subScopeId;
        return this;
    }

    public JobQueryImpl scopeType(String scopeType) {
        if (scopeType == null) {
            throw new FlowableIllegalArgumentException("Provided scope type is null");
        }
        this.scopeType = scopeType;
        return this;
    }

    public JobQueryImpl scopeDefinitionId(String scopeDefinitionId) {
        if (scopeDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Provided scope definitionid is null");
        }
        this.scopeDefinitionId = scopeDefinitionId;
        return this;
    }

    public JobQueryImpl caseInstanceId(String caseInstanceId) {
        if (caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("Provided case instance id is null");
        }
        this.scopeId(caseInstanceId);
        this.scopeType("cmmn");
        return this;
    }

    public JobQueryImpl caseDefinitionId(String caseDefinitionId) {
        if (caseDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Provided case definition id is null");
        }
        this.scopeDefinitionId(caseDefinitionId);
        this.scopeType("cmmn");
        return this;
    }

    public JobQueryImpl planItemInstanceId(String planItemInstanceId) {
        if (planItemInstanceId == null) {
            throw new FlowableIllegalArgumentException("Provided plan item instance id is null");
        }
        this.subScopeId(planItemInstanceId);
        this.scopeType("cmmn");
        return this;
    }

    public JobQueryImpl correlationId(String correlationId) {
        if (correlationId == null) {
            throw new FlowableIllegalArgumentException("Provided correlationId is null");
        }
        this.correlationId = correlationId;
        return this;
    }

    public JobQueryImpl executionId(String executionId) {
        if (executionId == null) {
            throw new FlowableIllegalArgumentException("Provided execution id is null");
        }
        this.executionId = executionId;
        return this;
    }

    public JobQueryImpl handlerType(String handlerType) {
        if (handlerType == null) {
            throw new FlowableIllegalArgumentException("Provided handlerType is null");
        }
        this.handlerType = handlerType;
        return this;
    }

    public JobQuery timers() {
        if (this.onlyMessages) {
            throw new FlowableIllegalArgumentException("Cannot combine onlyTimers() with onlyMessages() in the same query");
        }
        this.onlyTimers = true;
        return this;
    }

    public JobQuery messages() {
        if (this.onlyTimers) {
            throw new FlowableIllegalArgumentException("Cannot combine onlyTimers() with onlyMessages() in the same query");
        }
        this.onlyMessages = true;
        return this;
    }

    public JobQuery duedateHigherThan(Date date) {
        if (date == null) {
            throw new FlowableIllegalArgumentException("Provided date is null");
        }
        this.duedateHigherThan = date;
        return this;
    }

    public JobQuery duedateLowerThan(Date date) {
        if (date == null) {
            throw new FlowableIllegalArgumentException("Provided date is null");
        }
        this.duedateLowerThan = date;
        return this;
    }

    public JobQuery withException() {
        this.withException = true;
        return this;
    }

    public JobQuery exceptionMessage(String exceptionMessage) {
        if (exceptionMessage == null) {
            throw new FlowableIllegalArgumentException("Provided exception message is null");
        }
        this.exceptionMessage = exceptionMessage;
        return this;
    }

    public JobQuery jobTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("Provided tenant id is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    public JobQuery jobTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("Provided tenant id is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    public JobQuery jobWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    public JobQuery lockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
        return this;
    }

    public JobQuery locked() {
        this.onlyLocked = true;
        return this;
    }

    public JobQuery unlocked() {
        this.onlyUnlocked = true;
        return this;
    }

    public JobQuery orderByJobDuedate() {
        return (JobQuery)this.orderBy(JobQueryProperty.DUEDATE);
    }

    public JobQuery orderByExecutionId() {
        return (JobQuery)this.orderBy(JobQueryProperty.EXECUTION_ID);
    }

    public JobQuery orderByJobId() {
        return (JobQuery)this.orderBy(JobQueryProperty.JOB_ID);
    }

    public JobQuery orderByProcessInstanceId() {
        return (JobQuery)this.orderBy(JobQueryProperty.PROCESS_INSTANCE_ID);
    }

    public JobQuery orderByJobRetries() {
        return (JobQuery)this.orderBy(JobQueryProperty.RETRIES);
    }

    public JobQuery orderByTenantId() {
        return (JobQuery)this.orderBy(JobQueryProperty.TENANT_ID);
    }

    public long executeCount(CommandContext commandContext) {
        return this.jobServiceConfiguration.getJobEntityManager().findJobCountByQueryCriteria(this);
    }

    public List<Job> executeList(CommandContext commandContext) {
        return this.jobServiceConfiguration.getJobEntityManager().findJobsByQueryCriteria(this);
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getHandlerType() {
        return this.handlerType;
    }

    public Date getNow() {
        return this.jobServiceConfiguration.getClock().getCurrentTime();
    }

    public boolean isWithException() {
        return this.withException;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public String getId() {
        return this.id;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryLike() {
        return this.categoryLike;
    }

    public String getElementId() {
        return this.elementId;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public String getSubScopeId() {
        return this.subScopeId;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public String getScopeDefinitionId() {
        return this.scopeDefinitionId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public boolean isOnlyTimers() {
        return this.onlyTimers;
    }

    public boolean isOnlyMessages() {
        return this.onlyMessages;
    }

    public Date getDuedateHigherThan() {
        return this.duedateHigherThan;
    }

    public Date getDuedateLowerThan() {
        return this.duedateLowerThan;
    }

    public Date getDuedateHigherThanOrEqual() {
        return this.duedateHigherThanOrEqual;
    }

    public Date getDuedateLowerThanOrEqual() {
        return this.duedateLowerThanOrEqual;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public boolean isOnlyLocked() {
        return this.onlyLocked;
    }

    public boolean isOnlyUnlocked() {
        return this.onlyUnlocked;
    }
}

