/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.job.api.JobInfo;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.asyncexecutor.AsyncRunnableExecutionExceptionHandler;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.SuspendedJobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDebuggerExecutionExceptionHandler
implements AsyncRunnableExecutionExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDebuggerExecutionExceptionHandler.class);
    private static final String HANDLER_TYPE_BREAK_POINT = "breakpoint";

    @Override
    public boolean handleException(JobServiceConfiguration jobServiceConfiguration, JobInfo job, Throwable exception) {
        if (HANDLER_TYPE_BREAK_POINT.equals(job.getJobHandlerType())) {
            LOGGER.debug("break point execution throws an exception which will be swallowed", exception);
            jobServiceConfiguration.getCommandExecutor().execute(commandContext -> {
                JobEntity jobEntity = jobServiceConfiguration.getJobService().findJobById(job.getId());
                SuspendedJobEntity suspendedJobEntity = jobServiceConfiguration.getJobService().moveJobToSuspendedJob(jobEntity);
                if (exception != null) {
                    LOGGER.info("Debugger exception ", exception);
                    suspendedJobEntity.setExceptionMessage(exception.getMessage());
                    suspendedJobEntity.setExceptionStacktrace(ExceptionUtils.getStackTrace((Throwable)exception));
                }
                return null;
            });
            return true;
        }
        return false;
    }
}

