/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;

public class LuceneQueryParsingResult {
    private final Query query;
    private final String targetEntityName;
    private final Class<?> targetEntity;
    private final List<String> projections;
    private final Sort sort;

    public LuceneQueryParsingResult(Query query, String targetEntityName, Class<?> targetEntity, List<String> projections, Sort sort) {
        this.query = query;
        this.targetEntityName = targetEntityName;
        this.targetEntity = targetEntity;
        this.projections = projections != null ? projections : Collections.emptyList();
        this.sort = sort;
    }

    public Query getQuery() {
        return this.query;
    }

    public String getTargetEntityName() {
        return this.targetEntityName;
    }

    public Class<?> getTargetEntity() {
        return this.targetEntity;
    }

    public List<String> getProjections() {
        return this.projections;
    }

    public Sort getSort() {
        return this.sort;
    }

    public String toString() {
        return "LuceneQueryParsingResult [query=" + this.query + ", targetEntity=" + this.targetEntity + ", projections=" + this.projections + ", sort=" + this.sort + "]";
    }
}

