/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt.internal_5d10cad;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import org.jacoco.agent.rt.internal_5d10cad.ClassFileDumper;
import org.jacoco.agent.rt.internal_5d10cad.IExceptionLogger;
import org.jacoco.agent.rt.internal_5d10cad.core.instr.Instrumenter;
import org.jacoco.agent.rt.internal_5d10cad.core.runtime.AgentOptions;
import org.jacoco.agent.rt.internal_5d10cad.core.runtime.IRuntime;
import org.jacoco.agent.rt.internal_5d10cad.core.runtime.WildcardMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageTransformer
implements ClassFileTransformer {
    private static final String AGENT_PREFIX;
    private final IRuntime runtime;
    private final Instrumenter instrumenter;
    private final IExceptionLogger logger;
    private final WildcardMatcher includes;
    private final WildcardMatcher excludes;
    private final WildcardMatcher exclClassloader;
    private final ClassFileDumper classFileDumper;

    public CoverageTransformer(IRuntime runtime, AgentOptions options, IExceptionLogger logger) {
        this.runtime = runtime;
        this.instrumenter = new Instrumenter(runtime);
        this.logger = logger;
        this.includes = new WildcardMatcher(CoverageTransformer.toVMName(options.getIncludes()));
        this.excludes = new WildcardMatcher(CoverageTransformer.toVMName(options.getExcludes()));
        this.exclClassloader = new WildcardMatcher(options.getExclClassloader());
        this.classFileDumper = new ClassFileDumper(options.getClassDumpDir());
    }

    @Override
    public byte[] transform(ClassLoader loader, String classname, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (!this.filter(loader, classname)) {
            return null;
        }
        try {
            this.classFileDumper.dump(classname, classfileBuffer);
            if (classBeingRedefined != null) {
                this.runtime.disconnect(classBeingRedefined);
            }
            return this.instrumenter.instrument(classfileBuffer);
        }
        catch (Exception ex) {
            IllegalClassFormatException wrapper = new IllegalClassFormatException(String.format("Error while instrumenting class %s.", classname));
            wrapper.initCause(ex);
            this.logger.logExeption(wrapper);
            throw wrapper;
        }
    }

    protected boolean filter(ClassLoader loader, String classname) {
        return loader != null && !classname.startsWith(AGENT_PREFIX) && !this.exclClassloader.matches(loader.getClass().getName()) && this.includes.matches(classname) && !this.excludes.matches(classname);
    }

    private static String toVMName(String srcName) {
        return srcName.replace('.', '/');
    }

    static {
        String name = CoverageTransformer.class.getName();
        AGENT_PREFIX = CoverageTransformer.toVMName(name.substring(0, name.lastIndexOf(46)));
    }
}

