/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jacorb.notification.engine.PushTaskExecutor;
import org.jacorb.notification.interfaces.Disposable;

public class DefaultPushTaskExecutor
implements PushTaskExecutor,
Disposable {
    private static int noOfExecutors_ = 0;
    private final int executorNr_ = noOfExecutors_++;
    final LinkedBlockingQueue scheduledPushTasks_ = new LinkedBlockingQueue();
    final AtomicBoolean isActive_ = new AtomicBoolean(true);
    final List workers_ = new ArrayList();

    public DefaultPushTaskExecutor(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("At least 1 Worker");
        }
        this.createWorkers(n);
        this.startWorkers();
    }

    public void executePush(PushTaskExecutor.PushTask pushTask) {
        if (this.isActive_.get()) {
            try {
                this.scheduledPushTasks_.put((Object)pushTask);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void dispose() {
        this.isActive_.set(false);
        try {
            while (!this.scheduledPushTasks_.isEmpty()) {
                PushTaskExecutor.PushTask pushTask = (PushTaskExecutor.PushTask)this.scheduledPushTasks_.take();
                pushTask.cancel();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.disposeWorkers();
    }

    private void createWorkers(int n) {
        for (int i = 0; i < n; ++i) {
            Worker worker = new Worker("PushTaskExecutor#" + this.executorNr_ + "-" + i);
            this.workers_.add(worker);
        }
    }

    private void startWorkers() {
        Iterator iterator = this.workers_.iterator();
        while (iterator.hasNext()) {
            ((Thread)iterator.next()).start();
        }
    }

    private void disposeWorkers() {
        for (Thread thread : this.workers_) {
            thread.interrupt();
        }
        this.workers_.clear();
    }

    private class Worker
    extends Thread {
        public Worker(String string) {
            super(string);
        }

        public void run() {
            while (DefaultPushTaskExecutor.this.isActive_.get()) {
                try {
                    PushTaskExecutor.PushTask pushTask = (PushTaskExecutor.PushTask)DefaultPushTaskExecutor.this.scheduledPushTasks_.take();
                    if (!DefaultPushTaskExecutor.this.isActive_.get()) continue;
                    pushTask.doPush();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

