/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.remoting.RemotingMessages;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.management.ManagementChannelRegistryService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.xnio.OptionMap;

public abstract class AbstractChannelOpenListenerService<T>
implements Service<Void>,
OpenListener {
    protected final Logger log = Logger.getLogger((String)"org.jboss.as.remoting");
    private final InjectedValue<Endpoint> endpointValue = new InjectedValue();
    private final InjectedValue<ManagementChannelRegistryService> registry = new InjectedValue();
    protected final String channelName;
    private final OptionMap optionMap;
    private final Set<T> channels = Collections.synchronizedSet(new HashSet());
    private volatile boolean closed = true;

    public AbstractChannelOpenListenerService(String channelName, OptionMap optionMap) {
        this.channelName = channelName;
        this.optionMap = optionMap;
    }

    public ServiceName getServiceName(ServiceName endpointName) {
        return RemotingServices.channelServiceName(endpointName, this.channelName);
    }

    public InjectedValue<Endpoint> getEndpointInjector() {
        return this.endpointValue;
    }

    public InjectedValue<ManagementChannelRegistryService> getRegistry() {
        return this.registry;
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            this.closed = false;
            this.log.debugf("Registering channel listener for %s", (Object)this.channelName);
            Registration registration = ((Endpoint)this.endpointValue.getValue()).registerService(this.channelName, (OpenListener)this, this.optionMap);
            ((ManagementChannelRegistryService)this.registry.getValue()).register(registration);
        }
        catch (Exception e) {
            throw RemotingMessages.MESSAGES.couldNotStartChanelListener(e);
        }
    }

    public synchronized void stop(StopContext context) {
        this.closed = true;
    }

    public void channelOpened(Channel channel) {
        if (this.closed) {
            throw RemotingMessages.MESSAGES.channelShuttingDown();
        }
        final T createdChannel = this.createChannel(channel);
        this.channels.add(createdChannel);
        channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

            public void handleClose(Channel closed, IOException exception) {
                AbstractChannelOpenListenerService.this.channels.remove(createdChannel);
                AbstractChannelOpenListenerService.this.log.tracef("Handling close for %s", createdChannel);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registrationTerminated() {
        Set<T> set = this.channels;
        synchronized (set) {
            HashSet<T> copy = new HashSet<T>(this.channels);
            for (Object channel : copy) {
                this.closeChannelOnShutdown(channel);
            }
        }
    }

    protected abstract T createChannel(Channel var1);

    protected abstract void closeChannelOnShutdown(T var1);
}

