/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.List;
import java.util.Locale;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.subsystems.resourceadapters.CDConfigPropertiesService;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableConnDef;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubsystemProviders;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class CDConfigPropertyAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final CDConfigPropertyAdd INSTANCE = new CDConfigPropertyAdd();

    public ModelNode getModelDescription(Locale locale) {
        return ResourceAdaptersSubsystemProviders.ADD_CONFIG_PROPERTIES_DESC.getModelDescription(Locale.getDefault());
    }

    protected void populateModel(ModelNode operation, ModelNode modelNode) throws OperationFailedException {
        Constants.CONFIG_PROPERTY_VALUE.validateAndSet(operation, modelNode);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode recoveryEnvModel, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> serviceControllers) throws OperationFailedException {
        String configPropertyValue = Constants.CONFIG_PROPERTY_VALUE.resolveModelAttribute(context, recoveryEnvModel).asString();
        ModelNode address = operation.require("address");
        PathAddress path = PathAddress.pathAddress((ModelNode)address);
        String archiveName = path.getElement(path.size() - 3).getValue();
        String cfName = path.getElement(path.size() - 2).getValue();
        String configPropertyName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        ServiceName serviceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{archiveName, cfName, configPropertyName});
        ServiceName cfServiceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{archiveName, cfName});
        ServiceTarget serviceTarget = context.getServiceTarget();
        CDConfigPropertiesService service = new CDConfigPropertiesService(configPropertyName, configPropertyValue);
        ServiceController controller = serviceTarget.addService(serviceName, (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(cfServiceName, ModifiableConnDef.class, service.getRaInjector()).addListener((ServiceListener)verificationHandler).install();
    }
}

