/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMRFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;

public final class JDBCPostCreateEntityCommand {
    private final JDBCEntityBridge entity;
    private final JDBCCMRFieldBridge[] cmrWithFKMappedToCMP;

    public JDBCPostCreateEntityCommand(JDBCStoreManager manager) {
        this.entity = (JDBCEntityBridge)manager.getEntityBridge();
        JDBCAbstractCMRFieldBridge[] cmrFields = this.entity.getCMRFields();
        ArrayList<JDBCCMRFieldBridge> fkToCMPList = new ArrayList<JDBCCMRFieldBridge>(4);
        for (int i = 0; i < cmrFields.length; ++i) {
            JDBCCMRFieldBridge cmrField = (JDBCCMRFieldBridge)cmrFields[i];
            JDBCCMRFieldBridge relatedCMRField = (JDBCCMRFieldBridge)cmrField.getRelatedCMRField();
            if (!cmrField.hasFKFieldsMappedToCMPFields() && !relatedCMRField.hasFKFieldsMappedToCMPFields()) continue;
            fkToCMPList.add(cmrField);
        }
        this.cmrWithFKMappedToCMP = fkToCMPList.isEmpty() ? null : fkToCMPList.toArray(new JDBCCMRFieldBridge[fkToCMPList.size()]);
    }

    public Object execute(Method m, Object[] args, CmpEntityBeanContext ctx) {
        if (this.cmrWithFKMappedToCMP == null) {
            return null;
        }
        for (int i = 0; i < this.cmrWithFKMappedToCMP.length; ++i) {
            JDBCCMRFieldBridge cmrField = this.cmrWithFKMappedToCMP[i];
            JDBCCMRFieldBridge relatedCMRField = (JDBCCMRFieldBridge)cmrField.getRelatedCMRField();
            if (cmrField.hasFKFieldsMappedToCMPFields()) {
                Object relatedId = cmrField.getRelatedIdFromContext(ctx);
                if (relatedId == null) continue;
                try {
                    if (cmrField.isForeignKeyValid(relatedId)) {
                        cmrField.createRelationLinks(ctx, relatedId);
                        continue;
                    }
                    relatedCMRField.addRelatedPKWaitingForMyPK(relatedId, ctx.getPrimaryKey());
                }
                catch (Exception e) {}
                continue;
            }
            if (!relatedCMRField.hasFKFieldsMappedToCMPFields()) continue;
            cmrField.addRelatedPKsWaitedForMe(ctx);
        }
        return null;
    }
}

